/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt.cache;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Session;
import org.neo4j.jdbc.bolt.cache.BoltDriverCache;
import org.neo4j.jdbc.bolt.cache.BoltDriverCacheKey;

public class BoltDriverCached
implements Driver {
    private Driver internal;
    private BoltDriverCache cache;
    private BoltDriverCacheKey key;
    private final AtomicInteger sessionCounter = new AtomicInteger(0);

    public BoltDriverCached(Driver internal, BoltDriverCache cache, BoltDriverCacheKey key) {
        this.internal = internal;
        this.cache = cache;
        this.key = key;
    }

    @Override
    public boolean isEncrypted() {
        return this.internal.isEncrypted();
    }

    @Override
    public Session session() {
        this.sessionCounter.incrementAndGet();
        return this.internal.session();
    }

    @Override
    public Session session(AccessMode mode) {
        this.sessionCounter.incrementAndGet();
        return this.internal.session(mode);
    }

    @Override
    public Session session(String bookmark) {
        this.sessionCounter.incrementAndGet();
        return this.internal.session(bookmark);
    }

    @Override
    public Session session(AccessMode mode, String bookmark) {
        this.sessionCounter.incrementAndGet();
        return this.internal.session(mode, bookmark);
    }

    @Override
    public Session session(Iterable<String> bookmarks) {
        this.sessionCounter.incrementAndGet();
        return this.internal.session(bookmarks);
    }

    @Override
    public Session session(AccessMode mode, Iterable<String> bookmarks) {
        this.sessionCounter.incrementAndGet();
        return this.internal.session(mode, bookmarks);
    }

    @Override
    public void close() {
        if (this.sessionCounter.decrementAndGet() <= 0) {
            this.cache.removeFromCache(this.key);
            this.internal.close();
        }
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        return this.internal.closeAsync();
    }
}

