/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.jdbc.Neo4jDatabaseMetaData;
import org.neo4j.jdbc.bolt.impl.BoltNeo4jConnectionImpl;
import org.neo4j.jdbc.metadata.Column;
import org.neo4j.jdbc.metadata.Table;
import org.neo4j.jdbc.utils.Neo4jInvocationHandler;

public class BoltNeo4jDatabaseMetaData
extends Neo4jDatabaseMetaData {
    private static final Logger LOGGER = Logger.getLogger(BoltNeo4jDatabaseMetaData.class.getCanonicalName());
    private List<String> functions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoltNeo4jDatabaseMetaData(BoltNeo4jConnectionImpl connection) {
        super(connection);
        if (connection != null) {
            Session session = null;
            try {
                session = connection.newNeo4jSession();
                this.getDatabaseVersion(session);
                this.getDatabaseLabels(session);
                this.getDatabaseProperties(session);
                this.functions = this.callDbmsFunctions(session);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                connection.closeSession(session);
            }
        }
    }

    public static DatabaseMetaData newInstance(boolean debug, BoltNeo4jConnectionImpl connection) {
        BoltNeo4jDatabaseMetaData dbmd = new BoltNeo4jDatabaseMetaData(connection);
        return (DatabaseMetaData)Proxy.newProxyInstance(BoltNeo4jDatabaseMetaData.class.getClassLoader(), new Class[]{DatabaseMetaData.class}, (InvocationHandler)new Neo4jInvocationHandler(dbmd, debug));
    }

    private void getDatabaseVersion(Session session) {
        Record record;
        StatementResult rs = session.run("CALL dbms.components() yield name,versions WITH * WHERE name=\"Neo4j Kernel\" RETURN versions[0] AS version");
        if (rs != null && rs.hasNext() && (record = rs.next()).containsKey("version")) {
            this.databaseVersion = record.get("version").asString();
        }
    }

    private void getDatabaseLabels(Session session) {
        StatementResult rs = session.run("CALL db.labels() yield label return label");
        if (rs != null) {
            while (rs.hasNext()) {
                Record record = rs.next();
                this.databaseLabels.add(new Table(record.get("label").asString()));
            }
        }
    }

    private void getDatabaseProperties(Session session) {
        if (this.databaseLabels != null) {
            for (Table databaseLabel : this.databaseLabels) {
                StatementResult rs = session.run("MATCH (n:" + databaseLabel.getTableName() + ") WITH n LIMIT " + 1000 + " UNWIND keys(n) as key RETURN collect(distinct key) as keys");
                if (rs == null) continue;
                this.cycleResultSetToSetDatabaseProperties(rs, databaseLabel);
            }
        }
    }

    private void cycleResultSetToSetDatabaseProperties(StatementResult rs, Table databaseLabel) {
        while (rs.hasNext()) {
            Record record = rs.next();
            List<Object> keys = record.get("keys").asList();
            if (keys == null) continue;
            for (int i = 1; i <= keys.size(); ++i) {
                String key = (String)keys.get(i - 1);
                this.databaseProperties.add(new Column(databaseLabel.getTableName(), key, i));
            }
        }
    }

    private List<String> callDbmsFunctions(Session session) {
        ArrayList<String> functions = new ArrayList<String>();
        try {
            StatementResult rs = session.run("CALL dbms.functions() YIELD name, signature\nRETURN name \nORDER BY name ASC");
            while (rs != null && rs.hasNext()) {
                Record record = rs.next();
                functions.add(record.get("name").asString());
            }
            return functions;
        }
        catch (Exception e) {
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return String.join((CharSequence)",", this.functions);
    }
}

