/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.jdbc.bolt.cache.BoltDriverCache;
import org.neo4j.jdbc.bolt.impl.BoltNeo4jDriverImpl;

public class BoltDriver
extends BoltNeo4jDriverImpl {
    public static final String JDBC_BOLT_PREFIX = "bolt";
    private static final BoltDriverCache cache = new BoltDriverCache(params -> GraphDatabase.driver(params.getRoutingUris().get(0), params.getAuthToken(), params.getConfig()));

    public BoltDriver() throws SQLException {
        super(JDBC_BOLT_PREFIX);
    }

    @Override
    protected Driver getDriver(List<URI> routingUris, Config config, AuthToken authToken, Properties info) throws URISyntaxException {
        return cache.getDriver(routingUris, config, authToken, info);
    }

    @Override
    protected Properties getRoutingContext(String url, Properties properties) {
        return new Properties();
    }

    @Override
    protected String addRoutingPolicy(String url, Properties properties) {
        return url;
    }

    @Override
    protected List<URI> buildRoutingUris(String boltUrl, Properties properties) throws URISyntaxException {
        return Arrays.asList(new URI(boltUrl));
    }

    static {
        try {
            BoltDriver driver = new BoltDriver();
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

