/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import org.neo4j.jdbc.Loggable;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.Wrapper;
import org.neo4j.jdbc.impl.ListNeo4jResultSet;
import org.neo4j.jdbc.utils.ExceptionBuilder;

public abstract class Neo4jStatement
implements Statement,
Loggable {
    protected Neo4jConnection connection;
    protected ResultSet currentResultSet;
    protected int currentUpdateCount;
    protected List<String> batchStatements;
    protected boolean debug;
    protected int debugLevel;
    protected int[] resultSetParams;
    private int maxRows;
    private int queryTimeout;

    protected Neo4jStatement(Neo4jConnection connection) {
        this.connection = connection;
        this.currentResultSet = null;
        this.currentUpdateCount = -1;
        this.maxRows = 0;
        if (connection != null && connection.getProperties() != null) {
            this.maxRows = Integer.parseInt(connection.getProperties().getProperty("maxrows", "0"));
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement already closed");
        }
    }

    @Override
    public Neo4jConnection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        int update = this.currentUpdateCount;
        if (this.currentResultSet != null) {
            update = -1;
        } else {
            this.currentUpdateCount = -1;
        }
        return update;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        ResultSet rs = this.currentResultSet;
        this.currentResultSet = null;
        return rs;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        this.maxRows = max;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection == null || this.connection.isClosed();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            if (this.currentResultSet != null && !this.currentResultSet.isClosed()) {
                this.currentResultSet.close();
            }
            this.currentUpdateCount = -1;
            this.connection = null;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return Wrapper.unwrap(iface, this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return Wrapper.isWrapperFor(iface, this.getClass());
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows != Integer.MIN_VALUE && this.getMaxRows() > 0 && rows > this.getMaxRows()) {
            throw new UnsupportedOperationException("Not implemented yet. => maxRow :" + this.getMaxRows() + " rows :" + rows);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        return this.currentResultSet != null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        this.batchStatements.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.batchStatements.clear();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        if (this.currentResultSet != null) {
            return this.currentResultSet.getConcurrency();
        }
        if (this.resultSetParams.length > 1) {
            return this.resultSetParams[1];
        }
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        if (this.currentResultSet != null) {
            return this.currentResultSet.getType();
        }
        if (this.resultSetParams.length > 0) {
            return this.resultSetParams[0];
        }
        return 1003;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        if (this.currentResultSet != null) {
            return this.currentResultSet.getHoldability();
        }
        if (this.resultSetParams.length > 2) {
            return this.resultSetParams[2];
        }
        return 2;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return ListNeo4jResultSet.newInstance(false, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean hasDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void setDebugLevel(int level) {
        this.debugLevel = level;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }
}

