/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.neo4j.jdbc.Neo4jDriver;
import org.neo4j.jdbc.bolt.BoltDriver;
import org.neo4j.jdbc.boltrouting.BoltRoutingNeo4jDriver;
import org.neo4j.jdbc.http.HttpDriver;

public class Driver
extends Neo4jDriver {
    private static final Map<String, Class> DRIVERS = new HashMap<String, Class>();

    public Driver() throws SQLException {
        super(null);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Connection connection = null;
        if (null != this.getDriver(url)) {
            connection = this.getDriver(url).connect(url, info);
        }
        return connection;
    }

    private Neo4jDriver getDriver(String url) throws SQLException {
        String[] pieces;
        Neo4jDriver driver = null;
        if (url == null) {
            throw new SQLException("null is not a valid url");
        }
        if (url.startsWith("jdbc:neo4j:") && (pieces = url.split(":")).length > 3) {
            String prefix = pieces[2];
            driver = this.getDriverForPrefix(prefix);
        }
        return driver;
    }

    private Neo4jDriver getDriverForPrefix(String prefix) throws SQLException {
        Neo4jDriver driver = null;
        try {
            for (Map.Entry<String, Class> entry : DRIVERS.entrySet()) {
                if (!prefix.matches(entry.getKey())) continue;
                Constructor constructor = entry.getValue().getDeclaredConstructor(new Class[0]);
                driver = (Neo4jDriver)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return driver;
    }

    static {
        DRIVERS.put("bolt\\+routing", BoltRoutingNeo4jDriver.class);
        DRIVERS.put("bolt", BoltDriver.class);
        DRIVERS.put("http[s]?", HttpDriver.class);
    }
}

