/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.InternalNodeDynamicSize;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeDynamicSize;
import org.neo4j.index.internal.gbptree.OffloadStore;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.util.VisibleForTesting;

public class TreeNodeDynamicSize<KEY, VALUE>
extends TreeNode<KEY, VALUE> {
    static final byte FORMAT_IDENTIFIER = 3;
    static final byte FORMAT_VERSION = 0;

    TreeNodeDynamicSize(int payloadSize, Layout<KEY, VALUE> layout, OffloadStore<KEY, VALUE> offloadStore) {
        super(layout, new LeafNodeDynamicSize<KEY, VALUE>(payloadSize, layout, offloadStore), new InternalNodeDynamicSize<KEY>(payloadSize, layout, offloadStore));
    }

    public String toString() {
        return "TreeNodeDynamicSize[internal:" + this.internal + ", leaf:" + this.leaf + "]";
    }

    @VisibleForTesting
    void setAllocOffset(PageCursor cursor, int allocOffset) {
        PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)82, (int)allocOffset);
    }

    @VisibleForTesting
    int getAllocOffset(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort((PageCursor)cursor, (int)82);
    }

    @VisibleForTesting
    void setDeadSpace(PageCursor cursor, int deadSpace) {
        PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)84, (int)deadSpace);
    }

    @VisibleForTesting
    int getDeadSpace(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort((PageCursor)cursor, (int)84);
    }

    @VisibleForTesting
    public int getHeaderLength() {
        return 86;
    }
}

