/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.function.LongPredicate;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.kernel.api.impl.fulltext.FulltextResultCollector;
import org.neo4j.kernel.api.impl.fulltext.StatsCachingIndexSearcher;
import org.neo4j.kernel.api.impl.fulltext.StatsCollector;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.impl.index.partition.Neo4jIndexSearcher;

class PreparedSearch {
    private final Neo4jIndexSearcher searcher;
    private final LongPredicate filter;

    PreparedSearch(Neo4jIndexSearcher searcher, LongPredicate filter) {
        this.searcher = searcher;
        this.filter = filter;
    }

    Neo4jIndexSearcher searcher() {
        return this.searcher;
    }

    ValuesIterator search(Query query, IndexQueryConstraints constraints, StatsCollector statsCollector) throws IOException {
        FulltextResultCollector collector = new FulltextResultCollector(constraints, this.filter);
        StatsCachingIndexSearcher statsCachingIndexSearcher = new StatsCachingIndexSearcher(this, statsCollector);
        Weight weight = statsCachingIndexSearcher.createWeight(query, collector.scoreMode(), 1.0f);
        this.searcher.search(weight, (Collector)collector);
        return collector.iterator();
    }
}

