/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.DataAfterQuoteException;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.IllegalMultilineFieldException;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.SectionedCharBuffer;

public class BufferedCharSeeker
implements CharSeeker {
    private static final char EOL_CHAR = '\n';
    private static final char EOL_CHAR_2 = '\r';
    private static final char EOF_CHAR = '\uffff';
    private static final char BACK_SLASH = '\\';
    private final CharReadable reader;
    private char[] buffer;
    private SectionedCharBuffer charBuffer;
    private int bufferPos;
    private int bufferEnd;
    private int lineStartPos;
    private int seekStartPos;
    private int lineNumber;
    private boolean eof;
    private final char quoteChar;
    private long absoluteBufferStartPosition;
    private String sourceDescription;
    private final boolean multilineFields;

    public BufferedCharSeeker(CharReadable reader, Configuration config) {
        this.reader = reader;
        this.charBuffer = new SectionedCharBuffer(config.bufferSize());
        this.buffer = this.charBuffer.array();
        this.bufferPos = this.bufferEnd = this.charBuffer.pivot();
        this.quoteChar = config.quotationCharacter();
        this.lineStartPos = this.bufferPos;
        this.sourceDescription = reader.sourceDescription();
        this.multilineFields = config.multilineFields();
    }

    @Override
    public boolean seek(Mark mark, int untilChar) throws IOException {
        if (this.eof) {
            return this.eof(mark);
        }
        this.seekStartPos = this.bufferPos;
        int endOffset = 1;
        int skippedChars = 0;
        int quoteDepth = 0;
        boolean isQuoted = false;
        while (!this.eof) {
            int nextCh;
            int ch = this.nextChar(skippedChars);
            if (quoteDepth == 0) {
                if (ch == this.quoteChar && this.seekStartPos == this.bufferPos - 1) {
                    ++quoteDepth;
                    ++this.seekStartPos;
                    continue;
                }
                if (this.isNewLine(ch)) {
                    if (this.bufferPos - 1 != this.lineStartPos) break;
                    ++this.seekStartPos;
                    ++this.lineStartPos;
                    continue;
                }
                if (ch != untilChar) continue;
                mark.set(this.seekStartPos, this.bufferPos - endOffset - skippedChars, ch, isQuoted);
                return true;
            }
            isQuoted = true;
            if (ch == this.quoteChar) {
                nextCh = this.peekChar(skippedChars);
                if (nextCh == this.quoteChar) {
                    this.repositionChar(this.bufferPos++, ++skippedChars);
                    continue;
                }
                if (nextCh != untilChar && !this.isNewLine(nextCh) && nextCh != 65535) {
                    throw new DataAfterQuoteException(this, new String(this.buffer, this.seekStartPos, this.bufferPos - this.seekStartPos));
                }
                ++endOffset;
                --quoteDepth;
                continue;
            }
            if (this.isNewLine(ch)) {
                if (!this.multilineFields) {
                    throw new IllegalMultilineFieldException(this);
                }
                if (ch != 10) continue;
                ++this.lineNumber;
                continue;
            }
            if (ch != 92 || (nextCh = this.peekChar(skippedChars)) != this.quoteChar && nextCh != 92) continue;
            this.repositionChar(this.bufferPos++, ++skippedChars);
        }
        int valueLength = this.bufferPos - this.seekStartPos - 1;
        if (this.eof && valueLength == 0 && this.seekStartPos == this.lineStartPos) {
            return this.eof(mark);
        }
        ++this.lineNumber;
        this.lineStartPos = this.bufferPos;
        mark.set(this.seekStartPos, this.bufferPos - endOffset - skippedChars, Mark.END_OF_LINE_CHARACTER, isQuoted);
        return true;
    }

    private void repositionChar(int offset, int stepsBack) {
        this.buffer[offset - stepsBack] = this.buffer[offset];
    }

    private boolean isNewLine(int ch) {
        return ch == 10 || ch == 13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int peekChar(int skippedChars) throws IOException {
        int ch = this.nextChar(skippedChars);
        try {
            int n = ch;
            return n;
        }
        finally {
            if (ch != 65535) {
                --this.bufferPos;
            }
        }
    }

    private boolean eof(Mark mark) {
        mark.set(-1L, -1L, Mark.END_OF_LINE_CHARACTER, false);
        return false;
    }

    @Override
    public <EXTRACTOR extends Extractor<?>> EXTRACTOR extract(Mark mark, EXTRACTOR extractor) {
        if (!this.tryExtract(mark, extractor)) {
            throw new IllegalStateException(extractor + " didn't extract value for " + mark + ". For values which are optional please use tryExtract method instead");
        }
        return extractor;
    }

    @Override
    public boolean tryExtract(Mark mark, Extractor<?> extractor) {
        long from = mark.startPosition();
        long to = mark.position();
        return extractor.extract(this.buffer, (int)from, (int)(to - from), mark.isQuoted());
    }

    private int nextChar(int skippedChars) throws IOException {
        int ch;
        if (this.fillBufferIfWeHaveExhaustedIt()) {
            ch = this.buffer[this.bufferPos];
        } else {
            ch = 65535;
            this.eof = true;
        }
        if (skippedChars > 0) {
            this.repositionChar(this.bufferPos, skippedChars);
        }
        ++this.bufferPos;
        return ch;
    }

    private boolean fillBufferIfWeHaveExhaustedIt() throws IOException {
        if (this.bufferPos >= this.bufferEnd) {
            if (this.bufferPos - this.seekStartPos >= this.charBuffer.pivot()) {
                throw new IllegalStateException("Tried to read in a value larger than effective buffer size " + this.charBuffer.pivot());
            }
            this.absoluteBufferStartPosition += (long)this.charBuffer.available();
            this.charBuffer = this.reader.read(this.charBuffer, this.seekStartPos);
            this.buffer = this.charBuffer.array();
            this.bufferPos = this.charBuffer.pivot();
            this.bufferEnd = this.charBuffer.front();
            int shift = this.seekStartPos - this.charBuffer.back();
            this.seekStartPos = this.charBuffer.back();
            this.lineStartPos -= shift;
            String sourceDescriptionAfterRead = this.reader.sourceDescription();
            if (!this.sourceDescription.equals(sourceDescriptionAfterRead)) {
                this.lineNumber = 0;
                this.sourceDescription = sourceDescriptionAfterRead;
            }
            return this.charBuffer.hasAvailable();
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public long position() {
        return this.absoluteBufferStartPosition + (long)this.bufferPos;
    }

    @Override
    public String sourceDescription() {
        return this.sourceDescription;
    }

    @Override
    public long lineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        return String.format("%s[source:%s, position:%d, line:%d]", this.getClass().getSimpleName(), this.sourceDescription(), this.position(), this.lineNumber());
    }
}

