/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.store.synthetic.CountsEntry;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.consistency.store.synthetic.LabelScanDocument;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public interface ConsistencyReport {

    public static interface CountsConsistencyReport
    extends ConsistencyReport {
        @Documented(value="The node count does not correspond with the expected count.")
        public void inconsistentNodeCount(long var1);

        @Documented(value="The relationship count does not correspond with the expected count.")
        public void inconsistentRelationshipCount(long var1);

        @Documented(value="The node key entries in the store does not correspond with the expected number.")
        public void inconsistentNumberOfNodeKeys(long var1);

        @Documented(value="The relationship key entries in the store does not correspond with the expected number.")
        public void inconsistentNumberOfRelationshipKeys(long var1);
    }

    public static interface IndexConsistencyReport
    extends NodeInUseWithCorrectLabelsReport,
    RelationshipInUseWithCorrectRelationshipTypeReport {
        @Override
        @Documented(value="This index entry refers to a node record that is not in use.")
        public void nodeNotInUse(NodeRecord var1);

        @Override
        @Documented(value="This index entry refers to a relationship record that is not in use.")
        public void relationshipNotInUse(RelationshipRecord var1);

        @Override
        @Documented(value="This index entry refers to a node that does not have the expected label.")
        public void nodeDoesNotHaveExpectedLabel(NodeRecord var1, long var2);

        @Override
        @Documented(value="This index entry refers to a relationship that does not have the expected relationship type.")
        public void relationshipDoesNotHaveExpectedRelationshipType(RelationshipRecord var1, long var2);

        @Override
        @Documented(value="This node record has a label that is not found in the index for this node")
        public void nodeLabelNotInIndex(NodeRecord var1, long var2);

        @Warning
        @Documented(value="Index was not properly shutdown and rebuild is required.")
        public void dirtyIndex();

        @Documented(value="This index entry is for a relationship index, but it is used as a constraint index")
        public void relationshipConstraintIndex();
    }

    public static interface LabelScanConsistencyReport
    extends NodeInUseWithCorrectLabelsReport {
        @Override
        @Documented(value="This label scan document refers to a node record that is not in use.")
        public void nodeNotInUse(NodeRecord var1);

        @Override
        @Documented(value="This label scan document refers to a node that does not have the expected label.")
        public void nodeDoesNotHaveExpectedLabel(NodeRecord var1, long var2);

        @Override
        @Documented(value="This node record has a label that is not found in the label scan store entry for this node")
        public void nodeLabelNotInIndex(NodeRecord var1, long var2);

        @Warning
        @Documented(value="Label index was not properly shutdown and rebuild is required.")
        public void dirtyIndex();
    }

    public static interface RelationshipInUseWithCorrectRelationshipTypeReport
    extends ConsistencyReport {
        public void relationshipNotInUse(RelationshipRecord var1);

        public void relationshipDoesNotHaveExpectedRelationshipType(RelationshipRecord var1, long var2);
    }

    public static interface NodeInUseWithCorrectLabelsReport
    extends ConsistencyReport {
        public void nodeNotInUse(NodeRecord var1);

        public void nodeDoesNotHaveExpectedLabel(NodeRecord var1, long var2);

        public void nodeLabelNotInIndex(NodeRecord var1, long var2);
    }

    public static interface DynamicLabelConsistencyReport
    extends ConsistencyReport {
        @Documented(value="This label record is not referenced by its owning node record or that record is not in use.")
        public void orphanDynamicLabelRecordDueToInvalidOwner(NodeRecord var1);

        @Documented(value="This label record does not have an owning node record.")
        public void orphanDynamicLabelRecord();
    }

    public static interface DynamicConsistencyReport
    extends ConsistencyReport {
        @Documented(value="The next block is not in use.")
        public void nextNotInUse(DynamicRecord var1);

        @Warning
        @Documented(value="The record is not full, but references a next block.")
        public void recordNotFullReferencesNext();

        @Documented(value="The length of the block is invalid.")
        public void invalidLength();

        @Warning
        @Documented(value="The block is empty.")
        public void emptyBlock();

        @Warning
        @Documented(value="The next block is empty.")
        public void emptyNextBlock(DynamicRecord var1);

        @Documented(value="The next block references this (the same) record.")
        public void selfReferentialNext();

        @Documented(value="The next block of this record is also referenced by another dynamic record.")
        public void nextMultipleOwners(DynamicRecord var1);

        @Documented(value="The next block of this record is also referenced by a property record.")
        public void nextMultipleOwners(PropertyRecord var1);

        @Documented(value="The next block of this record is also referenced by a relationship type.")
        public void nextMultipleOwners(RelationshipTypeTokenRecord var1);

        @Documented(value="The next block of this record is also referenced by a property key.")
        public void nextMultipleOwners(PropertyKeyTokenRecord var1);

        @Documented(value="This record not referenced from any other dynamic block, or from any property or name record.")
        public void orphanDynamicRecord();
    }

    public static interface RelationshipGroupConsistencyReport
    extends ConsistencyReport {
        @Documented(value="The relationship type field has an illegal value.")
        public void illegalRelationshipType();

        @Documented(value="The relationship type record is not in use.")
        public void relationshipTypeNotInUse(RelationshipTypeTokenRecord var1);

        @Documented(value="The next relationship group is not in use.")
        public void nextGroupNotInUse();

        @Documented(value="The location of group in the chain is invalid, should be sorted by type ascending.")
        public void invalidTypeSortOrder();

        @Documented(value="The first outgoing relationship is not in use.")
        public void firstOutgoingRelationshipNotInUse();

        @Documented(value="The first incoming relationship is not in use.")
        public void firstIncomingRelationshipNotInUse();

        @Documented(value="The first loop relationship is not in use.")
        public void firstLoopRelationshipNotInUse();

        @Documented(value="The first outgoing relationship is not the first in its chain.")
        public void firstOutgoingRelationshipNotFirstInChain();

        @Documented(value="The first incoming relationship is not the first in its chain.")
        public void firstIncomingRelationshipNotFirstInChain();

        @Documented(value="The first loop relationship is not the first in its chain.")
        public void firstLoopRelationshipNotFirstInChain();

        @Documented(value="The first outgoing relationship is of a different type than its group.")
        public void firstOutgoingRelationshipOfOfOtherType();

        @Documented(value="The first incoming relationship is of a different type than its group.")
        public void firstIncomingRelationshipOfOfOtherType();

        @Documented(value="The first loop relationship is of a different type than its group.")
        public void firstLoopRelationshipOfOfOtherType();

        @Documented(value="The owner of the relationship group is not in use.")
        public void ownerNotInUse();

        @Documented(value="Illegal owner value.")
        public void illegalOwner();

        @Documented(value="Next chained relationship group has another owner.")
        public void nextHasOtherOwner(RelationshipGroupRecord var1);
    }

    public static interface PropertyKeyTokenConsistencyReport
    extends NameConsistencyReport {
        @Documented(value="The string record referred from this key is also referred from a another key.")
        public void nameMultipleOwners(PropertyKeyTokenRecord var1);
    }

    public static interface LabelTokenConsistencyReport
    extends NameConsistencyReport {
        @Documented(value="The string record referred from this label name is also referred from a another label name.")
        public void nameMultipleOwners(LabelTokenRecord var1);
    }

    public static interface RelationshipTypeConsistencyReport
    extends NameConsistencyReport {
        @Documented(value="The string record referred from this relationship type is also referred from a another relationship type.")
        public void nameMultipleOwners(RelationshipTypeTokenRecord var1);
    }

    public static interface NameConsistencyReport
    extends ConsistencyReport {
        @Documented(value="The name block is not in use.")
        public void nameBlockNotInUse(DynamicRecord var1);

        @Warning
        @Documented(value="The token name is empty. Empty token names are discouraged and also prevented in version 2.0.x and above, but they can be accessed just like any other tokens. It's possible that this token have been created in an earlier version where there were no checks for name being empty.")
        public void emptyName(DynamicRecord var1);

        @Documented(value="The string record referred from this name record is also referred from a another string record.")
        public void nameMultipleOwners(DynamicRecord var1);
    }

    public static interface PropertyConsistencyReport
    extends ConsistencyReport {
        @Documented(value="The property key as an invalid value.")
        public void invalidPropertyKey(PropertyBlock var1);

        @Documented(value="The key for this property is not in use.")
        public void keyNotInUse(PropertyBlock var1, PropertyKeyTokenRecord var2);

        @Documented(value="The previous property record is not in use.")
        public void prevNotInUse(PropertyRecord var1);

        @Documented(value="The next property record is not in use.")
        public void nextNotInUse(PropertyRecord var1);

        @Documented(value="The previous property record does not have this record as its next record.")
        public void previousDoesNotReferenceBack(PropertyRecord var1);

        @Documented(value="The next property record does not have this record as its previous record.")
        public void nextDoesNotReferenceBack(PropertyRecord var1);

        @Documented(value="The type of this property is invalid.")
        public void invalidPropertyType(PropertyBlock var1);

        @Documented(value="The string block is not in use.")
        public void stringNotInUse(PropertyBlock var1, DynamicRecord var2);

        @Documented(value="The array block is not in use.")
        public void arrayNotInUse(PropertyBlock var1, DynamicRecord var2);

        @Documented(value="The string block is empty.")
        public void stringEmpty(PropertyBlock var1, DynamicRecord var2);

        @Documented(value="The array block is empty.")
        public void arrayEmpty(PropertyBlock var1, DynamicRecord var2);

        @Documented(value="The property value is invalid.")
        public void invalidPropertyValue(PropertyBlock var1);

        @Documented(value="This record is first in a property chain, but no Node or Relationship records reference this record.")
        public void orphanPropertyChain();

        @Documented(value="The string property is not referenced anymore, but the corresponding block has not been deleted.")
        public void stringUnreferencedButNotDeleted(PropertyBlock var1);

        @Documented(value="The array property is not referenced anymore, but the corresponding block as not been deleted.")
        public void arrayUnreferencedButNotDeleted(PropertyBlock var1);

        @Documented(value="This property was declared to be changed for a node or relationship, but that node or relationship does not contain this property in its property chain.")
        public void ownerDoesNotReferenceBack();

        @Documented(value="This property was declared to be changed for a node or relationship, but that node or relationship did not contain this property in its property chain prior to the change. The property is referenced by another owner.")
        public void changedForWrongOwner();

        @Documented(value="The string record referred from this property is also referred from a another property.")
        public void stringMultipleOwners(PropertyRecord var1);

        @Documented(value="The array record referred from this property is also referred from a another property.")
        public void arrayMultipleOwners(PropertyRecord var1);

        @Documented(value="The string record referred from this property is also referred from a another string record.")
        public void stringMultipleOwners(DynamicRecord var1);

        @Documented(value="The array record referred from this property is also referred from a another array record.")
        public void arrayMultipleOwners(DynamicRecord var1);
    }

    public static interface RelationshipConsistencyReport
    extends PrimitiveConsistencyReport {
        @Documented(value="The relationship record is not in use, but referenced from relationships chain.")
        public void notUsedRelationshipReferencedInChain(RelationshipRecord var1);

        @Documented(value="The relationship type field has an illegal value.")
        public void illegalRelationshipType();

        @Documented(value="The relationship type record is not in use.")
        public void relationshipTypeNotInUse(RelationshipTypeTokenRecord var1);

        @Documented(value="The source node field has an illegal value.")
        public void illegalSourceNode();

        @Documented(value="The target node field has an illegal value.")
        public void illegalTargetNode();

        @Documented(value="The source node is not in use.")
        public void sourceNodeNotInUse(NodeRecord var1);

        @Documented(value="The target node is not in use.")
        public void targetNodeNotInUse(NodeRecord var1);

        @Documented(value="This record should be the first in the source chain, but the source node does not reference this record.")
        public void sourceNodeDoesNotReferenceBack(NodeRecord var1);

        @Documented(value="This record should be the first in the target chain, but the target node does not reference this record.")
        public void targetNodeDoesNotReferenceBack(NodeRecord var1);

        @Documented(value="The source node does not have a relationship chain.")
        public void sourceNodeHasNoRelationships(NodeRecord var1);

        @Documented(value="The target node does not have a relationship chain.")
        public void targetNodeHasNoRelationships(NodeRecord var1);

        @Documented(value="The previous record in the source chain is a relationship between two other nodes.")
        public void sourcePrevReferencesOtherNodes(RelationshipRecord var1);

        @Documented(value="The next record in the source chain is a relationship between two other nodes.")
        public void sourceNextReferencesOtherNodes(RelationshipRecord var1);

        @Documented(value="The previous record in the target chain is a relationship between two other nodes.")
        public void targetPrevReferencesOtherNodes(RelationshipRecord var1);

        @Documented(value="The next record in the target chain is a relationship between two other nodes.")
        public void targetNextReferencesOtherNodes(RelationshipRecord var1);

        @Documented(value="The previous record in the source chain does not have this record as its next record.")
        public void sourcePrevDoesNotReferenceBack(RelationshipRecord var1);

        @Documented(value="The next record in the source chain does not have this record as its previous record.")
        public void sourceNextDoesNotReferenceBack(RelationshipRecord var1);

        @Documented(value="The previous record in the target chain does not have this record as its next record.")
        public void targetPrevDoesNotReferenceBack(RelationshipRecord var1);

        @Documented(value="The next record in the target chain does not have this record as its previous record.")
        public void targetNextDoesNotReferenceBack(RelationshipRecord var1);

        @Documented(value="This relationship was not found in the expected index.")
        public void notIndexed(StoreIndexDescriptor var1, Object[] var2);

        @Documented(value="This relationship was found in the expected index, although multiple times")
        public void indexedMultipleTimes(StoreIndexDescriptor var1, Object[] var2, long var3);
    }

    public static interface NodeConsistencyReport
    extends PrimitiveConsistencyReport {
        @Documented(value="The referenced relationship record is not in use.")
        public void relationshipNotInUse(RelationshipRecord var1);

        @Documented(value="The referenced relationship record is a relationship between two other nodes.")
        public void relationshipForOtherNode(RelationshipRecord var1);

        @Documented(value="The referenced relationship record is not the first in the relationship chain where this node is source.")
        public void relationshipNotFirstInSourceChain(RelationshipRecord var1);

        @Documented(value="The referenced relationship record is not the first in the relationship chain where this node is target.")
        public void relationshipNotFirstInTargetChain(RelationshipRecord var1);

        @Documented(value="The label token record referenced from a node record is not in use.")
        public void labelNotInUse(LabelTokenRecord var1);

        @Documented(value="The label token record is referenced twice from the same node.")
        public void labelDuplicate(long var1);

        @Documented(value="The label id array is not ordered")
        public void labelsOutOfOrder(long var1, long var3);

        @Documented(value="The dynamic label record is not in use.")
        public void dynamicLabelRecordNotInUse(DynamicRecord var1);

        @Documented(value="This record points to a next record that was already part of this dynamic record chain.")
        public void dynamicRecordChainCycle(DynamicRecord var1);

        @Documented(value="This node was not found in the expected index.")
        public void notIndexed(StoreIndexDescriptor var1, Object[] var2);

        @Documented(value="This node was found in the expected index, although multiple times")
        public void indexedMultipleTimes(StoreIndexDescriptor var1, Object[] var2, long var3);

        @Documented(value="There is another node in the unique index with the same property value(s).")
        public void uniqueIndexNotUnique(StoreIndexDescriptor var1, Object[] var2, long var3);

        @Documented(value="The referenced relationship group record is not in use.")
        public void relationshipGroupNotInUse(RelationshipGroupRecord var1);

        @Documented(value="The first relationship group record has another node set as owner.")
        public void relationshipGroupHasOtherOwner(RelationshipGroupRecord var1);
    }

    public static interface SchemaConsistencyReport
    extends ConsistencyReport {
        @Documented(value="The label token record referenced from the schema is not in use.")
        public void labelNotInUse(LabelTokenRecord var1);

        @Documented(value="The relationship type token record referenced from the schema is not in use.")
        public void relationshipTypeNotInUse(RelationshipTypeTokenRecord var1);

        @Documented(value="The property key token record is not in use.")
        public void propertyKeyNotInUse(PropertyKeyTokenRecord var1);

        @Documented(value="The uniqueness constraint does not reference back to the given record")
        public void uniquenessConstraintNotReferencingBack(DynamicRecord var1);

        @Documented(value="The constraint index does not reference back to the given record")
        public void constraintIndexRuleNotReferencingBack(DynamicRecord var1);

        @Documented(value="This record is required to reference some other record of the given kind but no such obligation was found")
        public void missingObligation(SchemaRule.Kind var1);

        @Documented(value="This record requires some other record to reference back to it but there already was such a conflicting obligation created by the record given as a parameter")
        public void duplicateObligation(DynamicRecord var1);

        @Documented(value="This record contains a schema rule which has the same content as the schema rule contained in the record given as parameter")
        public void duplicateRuleContent(DynamicRecord var1);

        @Documented(value="The schema rule contained in the DynamicRecord chain is malformed (not deserializable)")
        public void malformedSchemaRule();

        @Documented(value="The schema rule contained in the DynamicRecord chain is of an unrecognized Kind")
        public void unsupportedSchemaRuleKind(SchemaRule.Kind var1);

        @Warning
        @Documented(value="The schema rule contained in the DynamicRecord chain has a reference to a schema rule that is not online.")
        public void schemaRuleNotOnline(SchemaRule var1);
    }

    public static interface NeoStoreConsistencyReport
    extends PrimitiveConsistencyReport {
    }

    public static interface PrimitiveConsistencyReport
    extends ConsistencyReport {
        @Documented(value="The referenced property record is not in use.")
        public void propertyNotInUse(PropertyRecord var1);

        @Documented(value="The referenced property record is not the first in its property chain.")
        public void propertyNotFirstInChain(PropertyRecord var1);

        @Documented(value="The referenced property is owned by another Node.")
        public void multipleOwners(NodeRecord var1);

        @Documented(value="The referenced property is owned by another Relationship.")
        public void multipleOwners(RelationshipRecord var1);

        @Documented(value="The referenced property is owned by the neo store (graph global property).")
        public void multipleOwners(NeoStoreRecord var1);

        @Documented(value="The property chain contains multiple properties that have the same property key id, which means that the entity has at least one duplicate property.")
        public void propertyKeyNotUniqueInChain();

        @Documented(value="The property chain does not contain a property that is mandatory for this entity.")
        public void missingMandatoryProperty(int var1);

        @Documented(value="The property record points to a previous record in the chain, making it a circular reference.")
        public void propertyChainContainsCircularReference(PropertyRecord var1);
    }

    public static interface Reporter {
        public void forSchema(DynamicRecord var1, RecordCheck<DynamicRecord, SchemaConsistencyReport> var2);

        public void forNode(NodeRecord var1, RecordCheck<NodeRecord, NodeConsistencyReport> var2);

        public void forRelationship(RelationshipRecord var1, RecordCheck<RelationshipRecord, RelationshipConsistencyReport> var2);

        public void forProperty(PropertyRecord var1, RecordCheck<PropertyRecord, PropertyConsistencyReport> var2);

        public void forRelationshipTypeName(RelationshipTypeTokenRecord var1, RecordCheck<RelationshipTypeTokenRecord, RelationshipTypeConsistencyReport> var2);

        public void forLabelName(LabelTokenRecord var1, RecordCheck<LabelTokenRecord, LabelTokenConsistencyReport> var2);

        public void forPropertyKey(PropertyKeyTokenRecord var1, RecordCheck<PropertyKeyTokenRecord, PropertyKeyTokenConsistencyReport> var2);

        public void forDynamicBlock(RecordType var1, DynamicRecord var2, RecordCheck<DynamicRecord, DynamicConsistencyReport> var3);

        public void forDynamicLabelBlock(RecordType var1, DynamicRecord var2, RecordCheck<DynamicRecord, DynamicLabelConsistencyReport> var3);

        public void forNodeLabelScan(LabelScanDocument var1, RecordCheck<LabelScanDocument, LabelScanConsistencyReport> var2);

        public void forIndexEntry(IndexEntry var1, RecordCheck<IndexEntry, IndexConsistencyReport> var2);

        public void forRelationshipGroup(RelationshipGroupRecord var1, RecordCheck<RelationshipGroupRecord, RelationshipGroupConsistencyReport> var2);

        public void forCounts(CountsEntry var1, RecordCheck<CountsEntry, CountsConsistencyReport> var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Warning {
    }
}

