/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

import java.time.Duration;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;

public final class BoltConnectorInternalSettings
implements SettingsDeclaration {
    @Internal
    @Description(value="The queue size of the thread pool bound to this connector (-1 for unbounded, 0 for direct handoff, > 0 for bounded)")
    public static final Setting<Integer> unsupported_thread_pool_queue_size = SettingImpl.newBuilder("dbms.connector.bolt.unsupported_thread_pool_queue_size", SettingValueParsers.INT, 0).build();
    @Internal
    @Description(value="The maximum time to wait before sending a NOOP on connections waiting for responses from active ongoing queries.")
    public static final Setting<Duration> connection_keep_alive = SettingImpl.newBuilder("dbms.connector.bolt.connection_keep_alive", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).build();
    @Internal
    @Description(value="The interval between every scheduled keep-alive check on all connections with active queries. Zero duration turns off keep-alive service.")
    public static final Setting<Duration> connection_keep_alive_scheduling_interval = SettingImpl.newBuilder("dbms.connector.bolt.connection_keep_alive_scheduling_interval", SettingValueParsers.DURATION, Duration.ofMinutes(0L)).build();
    @Internal
    @Description(value="The maximum time to wait for a user to finish authentication before closing the connection.")
    public static final Setting<Duration> unsupported_bolt_unauth_connection_timeout = SettingImpl.newBuilder("dbms.connector.bolt.unsupported_unauth_connection_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(30L)).build();
    @Internal
    @Description(value="The maximum inbound message size in bytes are allowed before a connection is authenticated.")
    public static final Setting<Long> unsupported_bolt_unauth_connection_max_inbound_bytes = SettingImpl.newBuilder("dbms.connector.bolt.unsupported_unauth_max_inbound_bytes", SettingValueParsers.BYTES, ByteUnit.kibiBytes((long)8L)).build();
}

