/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.error.reader;

import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.io.TypeMarker;

public class UnexpectedTypeException
extends PackstreamReaderException
implements Status.HasStatus {
    private final Type expected;
    private final Type actual;

    public UnexpectedTypeException(Type expected, Type actual) {
        super("Unexpected type: Expected " + expected + " but got " + actual);
        this.expected = expected;
        this.actual = actual;
    }

    public UnexpectedTypeException(Type actual) {
        super("Unexpected type: " + actual);
        this.expected = null;
        this.actual = actual;
    }

    public UnexpectedTypeException(Type expected, TypeMarker actual) {
        this(expected, actual.getType());
    }

    protected UnexpectedTypeException(String message, Type expected, Type actual) {
        super(message);
        this.expected = expected;
        this.actual = actual;
    }

    public Type getExpected() {
        return this.expected;
    }

    public Type getActual() {
        return this.actual;
    }

    public Status status() {
        return Status.Request.Invalid;
    }
}

