/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.codec.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.packstream.error.reader.LimitExceededException;
import org.neo4j.packstream.io.PackstreamBuf;

public class ChunkFrameDecoder
extends ByteToMessageDecoder {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ChunkFrameDecoder.class);
    private final long limit;
    private final InternalLog log;

    private ChunkFrameDecoder(long limit, InternalLog log) {
        this.limit = limit;
        this.log = log;
    }

    public ChunkFrameDecoder(long limit, InternalLogProvider logging) {
        this(limit, logging.getLog(ChunkFrameDecoder.class));
    }

    public ChunkFrameDecoder(InternalLogProvider logging) {
        this(-1L, logging);
    }

    public ChunkFrameDecoder unlimited() {
        return new ChunkFrameDecoder(-1L, this.log);
    }

    public ChunkFrameDecoder limit(long limit) {
        return new ChunkFrameDecoder(limit, this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws LimitExceededException {
        in.markReaderIndex();
        int totalLength = 0;
        ArrayList<ByteBuf> slices = new ArrayList<ByteBuf>();
        try {
            while (in.isReadable(2)) {
                int chunkLength = in.readUnsignedShort();
                if (chunkLength == 0) {
                    if (slices.isEmpty()) continue;
                    CompositeByteBuf msg = ctx.alloc().compositeBuffer(slices.size()).addComponents(true, slices);
                    out.add(PackstreamBuf.wrap((ByteBuf)msg));
                    totalLength = 0;
                    slices.clear();
                    in.markReaderIndex();
                    continue;
                }
                if (this.limit != -1L && (long)(totalLength += chunkLength) > this.limit) {
                    this.log.debug("Client %s has exceeded message size limit of %d bytes", new Object[]{ctx.channel().remoteAddress(), this.limit});
                    throw new LimitExceededException(this.limit, totalLength);
                }
                if (!in.isReadable(chunkLength)) {
                    break;
                }
                slices.add(in.readRetainedSlice(chunkLength));
            }
        }
        finally {
            slices.forEach(ReferenceCounted::release);
        }
        in.resetReaderIndex();
    }
}

