/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v44.fsm.state;

import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.connection.RouteMessage;
import org.neo4j.bolt.protocol.common.message.request.transaction.BeginMessage;
import org.neo4j.bolt.protocol.common.message.request.transaction.RunMessage;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class ReadyState
extends org.neo4j.bolt.protocol.v43.fsm.state.ReadyState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ReadyState.class);

    @Override
    public State processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        if (message instanceof RouteMessage || message instanceof RunMessage || message instanceof BeginMessage) {
            return super.processUnsafe(message, context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected State processRouteMessage(RouteMessage message, StateMachineContext context) throws Exception {
        RouteMessage routeMessage = message;
        context.connection().impersonate(routeMessage.impersonatedUser());
        try {
            State state = super.processRouteMessage(message, context);
            return state;
        }
        finally {
            context.connection().impersonate(null);
        }
    }

    @Override
    protected void onRoutingTableReceived(StateMachineContext context, RouteMessage message, MapValue routingTable) {
        String databaseName = message.getDatabaseName();
        if (databaseName == null) {
            context.connection().resolveDefaultDatabase();
            databaseName = context.connection().selectedDefaultDatabase();
        }
        super.onRoutingTableReceived(context, message, routingTable.updatedWith("db", (AnyValue)Values.stringValue((String)databaseName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected State processRunMessage(RunMessage message, StateMachineContext context) throws Exception {
        this.authenticateImpersonation(context, message.impersonatedUser());
        try {
            State state = super.processRunMessage(message, context);
            return state;
        }
        finally {
            context.connection().impersonate(null);
        }
    }

    @Override
    protected State processBeginMessage(BeginMessage message, StateMachineContext context) throws Exception {
        this.authenticateImpersonation(context, message.impersonatedUser());
        return super.processBeginMessage(message, context);
    }

    private void authenticateImpersonation(StateMachineContext context, String username) throws AuthenticationException {
        context.connection().impersonate(username);
    }
}

