/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.negotiation.codec.ProtocolNegotiationRequestDecoder;
import org.neo4j.bolt.negotiation.codec.ProtocolNegotiationResponseEncoder;
import org.neo4j.bolt.negotiation.message.ProtocolNegotiationRequest;
import org.neo4j.bolt.negotiation.message.ProtocolNegotiationResponse;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.codec.BoltStructEncoder;
import org.neo4j.bolt.protocol.common.connector.Connector;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.handler.HouseKeeperHandler;
import org.neo4j.bolt.protocol.common.handler.ProtocolLoggingHandler;
import org.neo4j.bolt.protocol.common.handler.RequestHandler;
import org.neo4j.bolt.protocol.common.handler.StateSignalFilterHandler;
import org.neo4j.bolt.protocol.common.handler.messages.GoodbyeMessageHandler;
import org.neo4j.bolt.protocol.common.message.response.ResponseMessage;
import org.neo4j.bolt.runtime.throttle.ChannelReadThrottleHandler;
import org.neo4j.bolt.runtime.throttle.ChannelWriteThrottleHandler;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.packstream.codec.PackstreamStructDecoder;
import org.neo4j.packstream.codec.PackstreamStructEncoder;
import org.neo4j.packstream.codec.transport.ChunkFrameDecoder;
import org.neo4j.packstream.codec.transport.ChunkFrameEncoder;
import org.neo4j.packstream.codec.transport.FrameSignalEncoder;

public class ProtocolHandshakeHandler
extends SimpleChannelInboundHandler<ProtocolNegotiationRequest> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ProtocolHandshakeHandler.class);
    public static final int BOLT_MAGIC_PREAMBLE = 1616949271;
    private final InternalLogProvider logging;
    private final InternalLog log;
    private final Config config;
    private final boolean enableProtocolLogging;
    private final BoltConnectorInternalSettings.ProtocolLoggingMode protocolLoggingMode;
    private Connector connector;
    private Connection connection;

    public ProtocolHandshakeHandler(Config config, boolean enableProtocolLogging, BoltConnectorInternalSettings.ProtocolLoggingMode protocolLoggingMode, InternalLogProvider logging) {
        this.config = config;
        this.enableProtocolLogging = enableProtocolLogging;
        this.protocolLoggingMode = protocolLoggingMode;
        this.logging = logging;
        this.log = logging.getLog(((Object)((Object)this)).getClass());
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.connection = Connection.getConnection(ctx.channel());
        this.connector = this.connection.connector();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ProtocolNegotiationRequest request) throws Exception {
        ChunkFrameDecoder frameDecoder;
        Long readLimit;
        if (request.getMagicNumber() != 1616949271) {
            this.log.debug("Invalid Bolt handshake signature. Expected 0x%08X, but got: 0x%08X", new Object[]{1616949271, request.getMagicNumber()});
            ctx.close();
            return;
        }
        BoltProtocol selectedProtocol = null;
        BoltProtocolRegistry protocolRegistry = this.connector.protocolRegistry();
        Iterator<ProtocolVersion> it = request.proposedVersions().iterator();
        do {
            if (!it.hasNext()) {
                this.log.debug("Failed Bolt handshake: Bolt versions suggested by client '%s' are not supported by this server.", new Object[]{Arrays.toString(request.proposedVersions().toArray())});
                ctx.writeAndFlush((Object)new ProtocolNegotiationResponse(ProtocolVersion.INVALID)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            ProtocolVersion proposal = it.next();
            if (ProtocolVersion.INVALID.equals(proposal)) continue;
            selectedProtocol = protocolRegistry.get(proposal).orElse(null);
        } while (selectedProtocol == null);
        BoltProtocol protocol = selectedProtocol;
        this.connection.selectProtocol(protocol);
        ctx.writeAndFlush((Object)new ProtocolNegotiationResponse(protocol.version()));
        ctx.pipeline().addLast(new ChannelHandler[]{new StateSignalFilterHandler()}).addLast(new ChannelHandler[]{new FrameSignalEncoder(protocol.frameSignalFilter())});
        if (((Boolean)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle)).booleanValue()) {
            ctx.channel().config().setWriteBufferWaterMark(new WriteBufferWaterMark(((Integer)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_low_water_mark)).intValue(), ((Integer)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_high_water_mark)).intValue()));
        }
        if ((readLimit = (Long)this.config.get(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes)) != 0L) {
            this.log.debug("Imposing %d byte read-limit on connection '%s' until authentication is completed", new Object[]{readLimit, this.connection.id()});
            frameDecoder = new ChunkFrameDecoder((long)readLimit, this.logging);
        } else {
            frameDecoder = new ChunkFrameDecoder(this.logging);
        }
        if (((Boolean)this.config.get(BoltConnectorInternalSettings.netty_message_merge_cumulator)).booleanValue()) {
            this.log.warn("Enabling merge cumulator for chunk decoding - Network performance may be degraded");
            frameDecoder.setCumulator(ByteToMessageDecoder.MERGE_CUMULATOR);
        }
        ctx.pipeline().addLast("chunkFrameDecoder", (ChannelHandler)frameDecoder);
        if (this.enableProtocolLogging && this.protocolLoggingMode.isLoggingRawTraffic()) {
            ctx.pipeline().remove("rawProtocolLoggingHandler");
            ctx.pipeline().addLast("rawProtocolLoggingHandler", (ChannelHandler)new ProtocolLoggingHandler(this.logging));
        }
        ctx.pipeline().addLast("chunkFrameEncoder", (ChannelHandler)new ChunkFrameEncoder()).addLast("structDecoder", new PackstreamStructDecoder<Connection>(this.connection, protocol.requestMessageRegistry(), this.logging)).addLast("structEncoder", new PackstreamStructEncoder<Connection, ResponseMessage>(ResponseMessage.class, this.connection, protocol.responseMessageRegistry()));
        Integer inboundMessageThrottleHighWatermark = (Integer)this.config.get(BoltConnectorInternalSettings.bolt_inbound_message_throttle_high_water_mark);
        if (inboundMessageThrottleHighWatermark != 0) {
            ctx.pipeline().addLast("readThrottleHandler", (ChannelHandler)new ChannelReadThrottleHandler((Integer)this.config.get(BoltConnectorInternalSettings.bolt_inbound_message_throttle_low_water_mark), inboundMessageThrottleHighWatermark, this.logging));
        }
        if (this.enableProtocolLogging && this.protocolLoggingMode.isLoggingDecodedTraffic()) {
            ctx.pipeline().remove("decodedProtocolLoggingHandler");
            ctx.pipeline().addLast("decodedProtocolLoggingHandler", (ChannelHandler)new ProtocolLoggingHandler(this.logging));
        }
        ctx.pipeline().addLast("goodbyeMessageHandler", (ChannelHandler)new GoodbyeMessageHandler(this.logging)).addLast("boltStructEncoder", (ChannelHandler)new BoltStructEncoder());
        Boolean writeThrottleEnabled = (Boolean)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle);
        long writeTimeoutMillis = ((Duration)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_max_duration)).toMillis();
        if (writeThrottleEnabled.booleanValue() && writeTimeoutMillis != 0L) {
            ctx.pipeline().addLast("channelThrottleHandler", (ChannelHandler)new ChannelWriteThrottleHandler(writeTimeoutMillis, this.logging));
        }
        ctx.pipeline().addLast("requestHandler", (ChannelHandler)new RequestHandler(this.logging)).addLast("housekeeper", (ChannelHandler)new HouseKeeperHandler(this.logging)).remove((ChannelHandler)this);
        ctx.pipeline().remove(ProtocolNegotiationResponseEncoder.class);
        ctx.pipeline().remove(ProtocolNegotiationRequestDecoder.class);
        this.connection.notifyListeners(listener -> listener.onProtocolSelected(protocol));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log.error("Fatal error occurred during protocol handshaking: " + ctx.channel(), cause);
        ctx.close();
    }
}

