/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.listener;

import java.time.Duration;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.listener.AuthenticationTimeoutConnectionListener;
import org.neo4j.bolt.protocol.common.connector.listener.ConnectorListener;
import org.neo4j.logging.InternalLogProvider;

public class AuthenticationTimeoutConnectorListener
implements ConnectorListener {
    private final Duration timeout;
    private final InternalLogProvider logging;

    public AuthenticationTimeoutConnectorListener(Duration timeout, InternalLogProvider logging) {
        this.timeout = timeout;
        this.logging = logging;
    }

    @Override
    public void onConnectionCreated(Connection connection) {
        connection.memoryTracker().allocateHeap(AuthenticationTimeoutConnectionListener.SHALLOW_SIZE);
        connection.registerListener(new AuthenticationTimeoutConnectionListener(connection, this.timeout, this.logging));
    }
}

