/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.util.Objects;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPIProvider;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.time.SystemNanoClock;

public abstract class AbstractTransactionStatementSPIProvider
implements TransactionStateMachineSPIProvider {
    protected final SystemNanoClock clock;
    protected final BoltChannel boltChannel;
    protected final String defaultDatabaseName;
    private final BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI;

    public AbstractTransactionStatementSPIProvider(BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, String defaultDatabaseName, BoltChannel boltChannel, SystemNanoClock clock) {
        this.boltGraphDatabaseManagementServiceSPI = boltGraphDatabaseManagementServiceSPI;
        this.defaultDatabaseName = defaultDatabaseName;
        this.clock = clock;
        this.boltChannel = boltChannel;
    }

    protected abstract TransactionStateMachineSPI newTransactionStateMachineSPI(BoltGraphDatabaseServiceSPI var1, StatementProcessorReleaseManager var2) throws BoltIOException;

    @Override
    public TransactionStateMachineSPI getTransactionStateMachineSPI(String databaseName, StatementProcessorReleaseManager resourceReleaseManger) throws BoltProtocolBreachFatality, BoltIOException {
        String selectedDatabaseName = this.selectDatabaseName(databaseName);
        try {
            BoltGraphDatabaseServiceSPI boltGraphDatabaseServiceSPI = this.boltGraphDatabaseManagementServiceSPI.database(selectedDatabaseName);
            return this.newTransactionStateMachineSPI(boltGraphDatabaseServiceSPI, resourceReleaseManger);
        }
        catch (DatabaseNotFoundException e) {
            throw new BoltIOException((Status)Status.Database.DatabaseNotFound, String.format("Database does not exist. Database name: '%s'.", selectedDatabaseName));
        }
        catch (UnavailableException e) {
            throw new BoltIOException((Status)Status.Database.DatabaseUnavailable, String.format("Database '%s' is unavailable.", selectedDatabaseName));
        }
    }

    protected String selectDatabaseName(String databaseName) throws BoltProtocolBreachFatality {
        if (!Objects.equals(databaseName, "")) {
            throw new BoltProtocolBreachFatality(String.format("Database selection by name not supported by Bolt protocol version lower than BoltV4. Please contact your Bolt client author to report this bug in the client code. Requested database name: '%s'.", databaseName));
        }
        return this.defaultDatabaseName;
    }
}

