/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.util.Map;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

class ExecutionPlanConverter {
    private ExecutionPlanConverter() {
    }

    public static MapValue convert(ExecutionPlanDescription plan) {
        boolean hasProfilerStatistics = plan.hasProfilerStatistics();
        int size = hasProfilerStatistics ? 10 : 4;
        MapValueBuilder out = new MapValueBuilder(size);
        out.add("operatorType", (AnyValue)Values.utf8Value((String)plan.getName()));
        out.add("args", (AnyValue)ValueUtils.asMapValue((Map)plan.getArguments()));
        out.add("identifiers", (AnyValue)ValueUtils.asListValue((Iterable)plan.getIdentifiers()));
        out.add("children", (AnyValue)ExecutionPlanConverter.children(plan));
        if (hasProfilerStatistics) {
            ExecutionPlanDescription.ProfilerStatistics profile = plan.getProfilerStatistics();
            if (profile.hasDbHits()) {
                out.add("dbHits", (AnyValue)Values.longValue((long)profile.getDbHits()));
            }
            if (profile.hasPageCacheStats()) {
                out.add("pageCacheHits", (AnyValue)Values.longValue((long)profile.getPageCacheHits()));
                out.add("pageCacheMisses", (AnyValue)Values.longValue((long)profile.getPageCacheMisses()));
                out.add("pageCacheHitRatio", (AnyValue)Values.doubleValue((double)profile.getPageCacheHitRatio()));
            }
            if (profile.hasRows()) {
                out.add("rows", (AnyValue)Values.longValue((long)profile.getRows()));
            }
            if (profile.hasTime()) {
                out.add("time", (AnyValue)Values.longValue((long)profile.getTime()));
            }
        }
        return out.build();
    }

    private static ListValue children(ExecutionPlanDescription plan) {
        ListValueBuilder.UnknownSizeListValueBuilder builder = ListValueBuilder.newListBuilder();
        for (ExecutionPlanDescription child : plan.getChildren()) {
            builder.add((AnyValue)ExecutionPlanConverter.convert(child));
        }
        return builder.build();
    }
}

