/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.Objects;

public class BoltProtocolVersion {
    private int majorVersion;
    private int minorVersion;

    public BoltProtocolVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public static BoltProtocolVersion fromRawBytes(int rawVersion) {
        int major = rawVersion & 0xFF;
        int minor = rawVersion >> 8 & 0xFF;
        return new BoltProtocolVersion(major, minor);
    }

    public long getMinorVersion() {
        return this.minorVersion;
    }

    public long getMajorVersion() {
        return this.majorVersion;
    }

    public int toInt() {
        int shiftedMinor = this.minorVersion << 8;
        return shiftedMinor | this.majorVersion;
    }

    public int hashCode() {
        return Objects.hash(this.minorVersion, this.majorVersion);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoltProtocolVersion)) {
            return false;
        }
        BoltProtocolVersion other = (BoltProtocolVersion)o;
        return this.getMajorVersion() == other.getMajorVersion() && this.getMinorVersion() == other.getMinorVersion();
    }
}

