/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import org.neo4j.util.FeatureToggles;

public class MessageAccumulator
extends ByteToMessageDecoder {
    private static final boolean USE_MERGE_CUMULATOR = FeatureToggles.flag(MessageAccumulator.class, (String)"mergeCumulator", (boolean)false);
    private boolean readMessageBoundary;

    public MessageAccumulator() {
        if (USE_MERGE_CUMULATOR) {
            this.setCumulator(MERGE_CUMULATOR);
        } else {
            this.setCumulator(COMPOSITE_CUMULATOR);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.readableBytes() == 0) {
            this.assertNonEmptyMessage();
            this.readMessageBoundary = true;
        }
        super.channelRead(ctx, msg);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf in, List<Object> out) {
        if (this.readMessageBoundary) {
            ByteBuf messageBuf = in.retainedDuplicate();
            in.readerIndex(in.readableBytes());
            out.add(messageBuf);
            this.readMessageBoundary = false;
        }
    }

    private void assertNonEmptyMessage() {
        if (this.actualReadableBytes() == 0) {
            throw new DecoderException("Message boundary received when there's nothing to decode.");
        }
    }
}

