/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.io.Writer;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.compat.LogBuilders;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;

@Generated(from="LogBuilders.writerLog", generator="Immutables")
public final class WriterLogBuilder {
    private static final long INIT_BIT_WRITER = 1L;
    private long initBits = 1L;
    private Writer writer;
    private Optional<Level> level = Optional.empty();
    private Optional<ZoneId> zoneId = Optional.empty();
    private Optional<DateTimeFormatter> dateTimeFormatter = Optional.empty();
    private Optional<String> category = Optional.empty();

    public WriterLogBuilder(Writer writer) {
        this.writer(writer);
    }

    private final WriterLogBuilder writer(Writer writer) {
        this.writer = Objects.requireNonNull(writer, "writer");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final WriterLogBuilder level(Level level) {
        this.level = Optional.of(level);
        return this;
    }

    public final WriterLogBuilder level(Optional<? extends Level> level) {
        this.level = Objects.requireNonNull(level, "level");
        return this;
    }

    public final WriterLogBuilder zoneId(ZoneId zoneId) {
        this.zoneId = Optional.of(zoneId);
        return this;
    }

    public final WriterLogBuilder zoneId(Optional<? extends ZoneId> zoneId) {
        this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
        return this;
    }

    public final WriterLogBuilder dateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = Optional.of(dateTimeFormatter);
        return this;
    }

    public final WriterLogBuilder dateTimeFormatter(Optional<? extends DateTimeFormatter> dateTimeFormatter) {
        this.dateTimeFormatter = Objects.requireNonNull(dateTimeFormatter, "dateTimeFormatter");
        return this;
    }

    public final WriterLogBuilder category(String category) {
        this.category = Optional.of(category);
        return this;
    }

    public final WriterLogBuilder category(Optional<String> category) {
        this.category = Objects.requireNonNull(category, "category");
        return this;
    }

    public Log build() {
        this.checkRequiredAttributes();
        return LogBuilders.writerLog(this.writer, this.level, this.zoneId, this.dateTimeFormatter, this.category);
    }

    private boolean writerIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.writerIsSet()) {
            attributes.add("writer");
        }
        return "Cannot build writerLog, some of required attributes are not set " + attributes;
    }
}

