/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.jetbrains.annotations.Nullable;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.gds.annotation.SuppressForbidden;
import org.neo4j.gds.compat.CompatIndexQuery;
import org.neo4j.gds.compat.CompatInput;
import org.neo4j.gds.compat.CompositeNodeCursor;
import org.neo4j.gds.compat.CustomAccessMode;
import org.neo4j.gds.compat.GdsGraphDatabaseAPI;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.JobRunner;
import org.neo4j.gds.compat.LogBuilders;
import org.neo4j.gds.compat.MemoryTrackerProxy;
import org.neo4j.gds.compat.Neo4jProxyApi;
import org.neo4j.gds.compat.Neo4jProxyFactory;
import org.neo4j.gds.compat.Neo4jVersion;
import org.neo4j.gds.compat.PropertyReference;
import org.neo4j.gds.compat.StoreScan;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.ImportLogic;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.OffHeapLongArray;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.procedure.Mode;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

@SuppressForbidden(reason="This is the best we can do at the moment")
public final class Neo4jProxy {
    private static final Neo4jProxyApi IMPL;

    public static GdsGraphDatabaseAPI newDb(DatabaseManagementService dbms) {
        return IMPL.newDb(dbms);
    }

    public static String validateExternalDatabaseName(String databaseName) {
        return IMPL.validateExternalDatabaseName(databaseName);
    }

    public static void cacheDatabaseId(DatabaseIdRepository.Caching databaseIdRepository, NamedDatabaseId namedDatabaseId) {
        IMPL.cacheDatabaseId(databaseIdRepository, namedDatabaseId);
    }

    public static AccessMode accessMode(CustomAccessMode customAccessMode) {
        return IMPL.accessMode(customAccessMode);
    }

    public static AccessMode newRestrictedAccessMode(AccessMode original, AccessMode.Static restricting) {
        return IMPL.newRestrictedAccessMode(original, restricting);
    }

    public static String username(AuthSubject subject) {
        return IMPL.username(subject);
    }

    public static SecurityContext securityContext(String username, AuthSubject authSubject, AccessMode mode, String databaseName) {
        return IMPL.securityContext(username, authSubject, mode, databaseName);
    }

    public static long getHighestPossibleIdInUse(RecordStore<? extends AbstractBaseRecord> recordStore, KernelTransaction kernelTransaction) {
        return IMPL.getHighestPossibleIdInUse(recordStore, kernelTransaction);
    }

    public static PageCursor pageFileIO(PagedFile pagedFile, long pageId, int pageFileFlags) throws IOException {
        return IMPL.pageFileIO(pagedFile, pageId, pageFileFlags);
    }

    public static PagedFile pageCacheMap(PageCache pageCache, File file, int pageSize, String databaseName, OpenOption ... openOptions) throws IOException {
        return IMPL.pageCacheMap(pageCache, file, pageSize, databaseName, openOptions);
    }

    public static Path pagedFile(PagedFile pagedFile) {
        return IMPL.pagedFile(pagedFile);
    }

    public static List<StoreScan<NodeLabelIndexCursor>> entityCursorScan(KernelTransaction transaction, int[] labelIds, int batchSize) {
        return IMPL.entityCursorScan(transaction, labelIds, batchSize);
    }

    public static PropertyCursor allocatePropertyCursor(KernelTransaction kernelTransaction) {
        return IMPL.allocatePropertyCursor(kernelTransaction);
    }

    public static PropertyReference propertyReference(NodeCursor nodeCursor) {
        return IMPL.propertyReference(nodeCursor);
    }

    public static PropertyReference propertyReference(RelationshipScanCursor relationshipScanCursor) {
        return IMPL.propertyReference(relationshipScanCursor);
    }

    public static PropertyReference noPropertyReference() {
        return IMPL.noPropertyReference();
    }

    public static void nodeProperties(KernelTransaction kernelTransaction, long nodeReference, PropertyReference reference, PropertyCursor cursor) {
        IMPL.nodeProperties(kernelTransaction, nodeReference, reference, cursor);
    }

    public static void relationshipProperties(KernelTransaction kernelTransaction, long relationshipReference, PropertyReference reference, PropertyCursor cursor) {
        IMPL.relationshipProperties(kernelTransaction, relationshipReference, reference, cursor);
    }

    public static NodeCursor allocateNodeCursor(KernelTransaction kernelTransaction) {
        return IMPL.allocateNodeCursor(kernelTransaction);
    }

    public static RelationshipScanCursor allocateRelationshipScanCursor(KernelTransaction kernelTransaction) {
        return IMPL.allocateRelationshipScanCursor(kernelTransaction);
    }

    public static NodeLabelIndexCursor allocateNodeLabelIndexCursor(KernelTransaction kernelTransaction) {
        return IMPL.allocateNodeLabelIndexCursor(kernelTransaction);
    }

    public static NodeValueIndexCursor allocateNodeValueIndexCursor(KernelTransaction kernelTransaction) {
        return IMPL.allocateNodeValueIndexCursor(kernelTransaction);
    }

    public static long relationshipsReference(NodeCursor nodeCursor) {
        return IMPL.relationshipsReference(nodeCursor);
    }

    public static boolean hasNodeLabelIndex(KernelTransaction kernelTransaction) {
        return IMPL.hasNodeLabelIndex(kernelTransaction);
    }

    public static void nodeLabelScan(KernelTransaction kernelTransaction, int label, NodeLabelIndexCursor cursor) {
        IMPL.nodeLabelScan(kernelTransaction, label, cursor);
    }

    public static StoreScan<NodeLabelIndexCursor> nodeLabelIndexScan(KernelTransaction transaction, int labelId, int batchSize) {
        return IMPL.nodeLabelIndexScan(transaction, labelId, batchSize);
    }

    public static <C extends Cursor> StoreScan<C> scanToStoreScan(Scan<C> scan, int batchSize) {
        return IMPL.scanToStoreScan(scan, batchSize);
    }

    public static void nodeIndexScan(Read dataRead, IndexReadSession index, NodeValueIndexCursor cursor, IndexOrder indexOrder, boolean needsValues) throws Exception {
        IMPL.nodeIndexScan(dataRead, index, cursor, indexOrder, needsValues);
    }

    public static CompatIndexQuery rangeIndexQuery(int propertyKeyId, double from, boolean fromInclusive, double to, boolean toInclusive) {
        return IMPL.rangeIndexQuery(propertyKeyId, from, fromInclusive, to, toInclusive);
    }

    public static CompatIndexQuery rangeAllIndexQuery(int propertyKeyId) {
        return IMPL.rangeAllIndexQuery(propertyKeyId);
    }

    public static void nodeIndexSeek(Read dataRead, IndexReadSession index, NodeValueIndexCursor cursor, IndexOrder indexOrder, boolean needsValues, CompatIndexQuery query) throws Exception {
        IMPL.nodeIndexSeek(dataRead, index, cursor, indexOrder, needsValues, query);
    }

    public static CompositeNodeCursor compositeNodeCursor(List<NodeLabelIndexCursor> cursors, int[] labelIds) {
        return IMPL.compositeNodeCursor(cursors, labelIds);
    }

    public static OffHeapLongArray newOffHeapLongArray(long length, long defaultValue, long base) {
        return IMPL.newOffHeapLongArray(length, defaultValue, base);
    }

    public static LongArray newChunkedLongArray(NumberArrayFactory numberArrayFactory, int size, long defaultValue) {
        return IMPL.newChunkedLongArray(numberArrayFactory, size, defaultValue);
    }

    public static MemoryTrackerProxy memoryTrackerProxy(KernelTransaction kernelTransaction) {
        return IMPL.memoryTrackerProxy(kernelTransaction);
    }

    public static MemoryTrackerProxy emptyMemoryTrackerProxy() {
        return IMPL.emptyMemoryTracker();
    }

    public static MemoryTrackerProxy limitedMemoryTrackerProxy(long limitInBytes, long grabSizeInBytes) {
        return IMPL.limitedMemoryTracker(limitInBytes, grabSizeInBytes);
    }

    public static LogService logProviderForStoreAndRegister(Path storeLogPath, FileSystemAbstraction fs, LifeSupport lifeSupport) throws IOException {
        return IMPL.logProviderForStoreAndRegister(storeLogPath, fs, lifeSupport);
    }

    public static Path metadataStore(DatabaseLayout databaseLayout) {
        return IMPL.metadataStore(databaseLayout);
    }

    public static Path homeDirectory(DatabaseLayout databaseLayout) {
        return IMPL.homeDirectory(databaseLayout);
    }

    public static BatchImporter instantiateBatchImporter(BatchImporterFactory factory, DatabaseLayout directoryStructure, FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, int writeConcurrency, Optional<Long> pageCacheMemory, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig, RecordFormats recordFormats, ImportLogic.Monitor monitor, JobScheduler jobScheduler, Collector badCollector) {
        return IMPL.instantiateBatchImporter(factory, directoryStructure, fileSystem, pageCacheTracer, writeConcurrency, pageCacheMemory, logService, executionMonitor, additionalInitialIds, dbConfig, recordFormats, monitor, jobScheduler, badCollector);
    }

    public static Input batchInputFrom(CompatInput compatInput) {
        return IMPL.batchInputFrom(compatInput);
    }

    public static String queryText(ExecutingQuery query) {
        return IMPL.queryText(query);
    }

    public static Log logger(Level level, ZoneId zoneId, DateTimeFormatter dateTimeFormatter, String category, PrintWriter writer) {
        return IMPL.logger(level, zoneId, dateTimeFormatter, category, writer);
    }

    public static Log logger(Level level, ZoneId zoneId, DateTimeFormatter dateTimeFormatter, String category, OutputStream outputStream) {
        return IMPL.logger(level, zoneId, dateTimeFormatter, category, outputStream);
    }

    public static Setting<Boolean> onlineBackupEnabled() {
        return IMPL.onlineBackupEnabled();
    }

    public static Setting<String> additionalJvm() {
        return IMPL.additionalJvm();
    }

    public static Setting<Long> memoryTransactionMaxSize() {
        return IMPL.memoryTransactionMaxSize();
    }

    public static JobRunner runnerFromScheduler(JobScheduler scheduler, Group group) {
        return IMPL.runnerFromScheduler(scheduler, group);
    }

    public static ExecutionMonitor invisibleExecutionMonitor() {
        return IMPL.invisibleExecutionMonitor();
    }

    public static UserFunctionSignature userFunctionSignature(QualifiedName name, List<FieldSignature> inputSignature, Neo4jTypes.AnyType type, String deprecated, String[] allowed, String description, String category, boolean caseInsensitive) {
        return IMPL.userFunctionSignature(name, inputSignature, type, deprecated, allowed, description, category, caseInsensitive);
    }

    public static ProcedureSignature procedureSignature(QualifiedName name, List<FieldSignature> inputSignature, List<FieldSignature> outputSignature, Mode mode, boolean admin, String deprecated, String[] allowed, String description, String warning, boolean eager, boolean caseInsensitive, boolean systemProcedure, boolean internal, boolean allowExpiredCredentials) {
        return IMPL.procedureSignature(name, inputSignature, outputSignature, mode, admin, deprecated, allowed, description, warning, eager, caseInsensitive, systemProcedure, internal, allowExpiredCredentials);
    }

    public static long getHighestPossibleNodeCount(Read read, @Nullable IdGeneratorFactory idGeneratorFactory) {
        return IMPL.getHighestPossibleNodeCount(read, idGeneratorFactory);
    }

    public static long getHighestPossibleRelationshipCount(Read read, @Nullable IdGeneratorFactory idGeneratorFactory) {
        return IMPL.getHighestPossibleRelationshipCount(read, idGeneratorFactory);
    }

    private Neo4jProxy() {
        throw new UnsupportedOperationException("No instances");
    }

    static {
        Neo4jVersion neo4jVersion = GraphDatabaseApiProxy.neo4jVersion();
        Neo4jProxyFactory neo4jProxyFactory = ServiceLoader.load(Neo4jProxyFactory.class).stream().map(ServiceLoader.Provider::get).filter(f -> f.canLoad(neo4jVersion)).findFirst().orElseThrow(() -> new LinkageError("Could not load the " + Neo4jProxy.class + " implementation for " + neo4jVersion));
        IMPL = neo4jProxyFactory.load();
        Log log = LogBuilders.outputStreamLog(System.out, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        log.info("Loaded compatibility layer: %s", new Object[]{IMPL.getClass()});
        log.info("Loaded version: %s", new Object[]{neo4jVersion});
    }
}

