/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import org.immutables.builder.Builder;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;

public final class LogBuilders {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSZ", Locale.ENGLISH);

    @Builder.Factory
    public static Log outputStreamLog(@Builder.Parameter OutputStream outputStream, Optional<Level> level, Optional<ZoneId> zoneId, Optional<DateTimeFormatter> dateTimeFormatter, Optional<String> category) {
        return Neo4jProxy.logger(level.orElse(Level.INFO), zoneId.orElse(ZoneOffset.UTC), dateTimeFormatter.orElse(DATE_TIME_FORMATTER), (String)category.orElse(null), outputStream);
    }

    @Builder.Factory
    public static Log writerLog(@Builder.Parameter Writer writer, Optional<Level> level, Optional<ZoneId> zoneId, Optional<DateTimeFormatter> dateTimeFormatter, Optional<String> category) {
        return Neo4jProxy.logger(level.orElse(Level.INFO), zoneId.orElse(ZoneOffset.UTC), dateTimeFormatter.orElse(DATE_TIME_FORMATTER), (String)category.orElse(null), writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer));
    }

    private LogBuilders() {
        throw new UnsupportedOperationException("No instances");
    }
}

