/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.utils.cypher;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;

@Value.Style(builderVisibility=Value.Style.BuilderVisibility.PUBLIC, deferCollectionAllocation=true, depluralize=true, add="add", addAll="addAll")
final class ScalaHelpers {
    @Builder.Factory
    static <T> List<T> scalaList(java.util.List<T> items) {
        return items.stream().collect(ScalaHelpers.toScala());
    }

    static <T, U> Tuple2<T, U> pair(T left, @Nullable U right) {
        return Tuple2.apply(left, right);
    }

    private static <T> Collector<T, ?, List<T>> toScala() {
        return new ScalaSeqCollector(ListBuffer::toList);
    }

    private ScalaHelpers() {
    }

    private static final class ScalaSeqCollector<T, R>
    implements Collector<T, ListBuffer<T>, R>,
    Supplier<ListBuffer<T>>,
    BiConsumer<ListBuffer<T>, T>,
    BinaryOperator<ListBuffer<T>> {
        private final Function<ListBuffer<T>, R> finisher;

        private ScalaSeqCollector(Function<ListBuffer<T>, R> finisher) {
            this.finisher = finisher;
        }

        @Override
        public Supplier<ListBuffer<T>> supplier() {
            return this;
        }

        @Override
        public ListBuffer<T> get() {
            return new ListBuffer();
        }

        @Override
        public BiConsumer<ListBuffer<T>, T> accumulator() {
            return this;
        }

        @Override
        public void accept(ListBuffer<T> buffer, T t) {
            buffer.$plus$eq(t);
        }

        @Override
        public BinaryOperator<ListBuffer<T>> combiner() {
            return this;
        }

        @Override
        public ListBuffer<T> apply(ListBuffer<T> left, ListBuffer<T> right) {
            left.$plus$plus$eq(right);
            return left;
        }

        @Override
        public Function<ListBuffer<T>, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

