/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.api.schema.RelationshipSchema;

@Generated(from="RelationshipSchema", generator="Immutables")
public final class ImmutableRelationshipSchema
implements RelationshipSchema {
    private final Map<RelationshipType, Map<String, RelationshipPropertySchema>> properties;
    private final transient Set<String> allProperties;
    private final transient boolean hasProperties;
    private final transient Map<String, Object> toMap;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long UNION_PROPERTIES_LAZY_INIT_BIT = 1L;
    private transient Map<String, RelationshipPropertySchema> unionProperties;

    private ImmutableRelationshipSchema(Map<? extends RelationshipType, ? extends Map<String, RelationshipPropertySchema>> properties) {
        this.properties = ImmutableRelationshipSchema.createUnmodifiableMap(true, false, properties);
        this.allProperties = this.initShim.allProperties();
        this.hasProperties = this.initShim.hasProperties();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private ImmutableRelationshipSchema(ImmutableRelationshipSchema original, Map<RelationshipType, Map<String, RelationshipPropertySchema>> properties) {
        this.properties = properties;
        this.allProperties = this.initShim.allProperties();
        this.hasProperties = this.initShim.hasProperties();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private Set<String> allPropertiesInitialize() {
        return RelationshipSchema.super.allProperties();
    }

    private boolean hasPropertiesInitialize() {
        return RelationshipSchema.super.hasProperties();
    }

    private Map<String, Object> toMapInitialize() {
        return RelationshipSchema.super.toMap();
    }

    @Override
    public Map<RelationshipType, Map<String, RelationshipPropertySchema>> properties() {
        return this.properties;
    }

    @Override
    public Set<String> allProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allProperties() : this.allProperties;
    }

    @Override
    public boolean hasProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasProperties() : this.hasProperties;
    }

    @Override
    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public final ImmutableRelationshipSchema withProperties(Map<? extends RelationshipType, ? extends Map<String, RelationshipPropertySchema>> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<RelationshipType, Map<String, RelationshipPropertySchema>> newValue = ImmutableRelationshipSchema.createUnmodifiableMap(true, false, entries);
        return new ImmutableRelationshipSchema(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationshipSchema && this.equalTo((ImmutableRelationshipSchema)another);
    }

    private boolean equalTo(ImmutableRelationshipSchema another) {
        return this.properties.equals(another.properties) && this.allProperties.equals(another.allProperties) && this.hasProperties == another.hasProperties && this.toMap.equals(another.toMap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.allProperties.hashCode();
        h += (h << 5) + Boolean.hashCode(this.hasProperties);
        h += (h << 5) + this.toMap.hashCode();
        return h;
    }

    public String toString() {
        return "RelationshipSchema{properties=" + this.properties + ", allProperties=" + this.allProperties + ", hasProperties=" + this.hasProperties + ", toMap=" + this.toMap + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, RelationshipPropertySchema> unionProperties() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableRelationshipSchema immutableRelationshipSchema = this;
            synchronized (immutableRelationshipSchema) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.unionProperties = Objects.requireNonNull(RelationshipSchema.super.unionProperties(), "unionProperties");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.unionProperties;
    }

    public static RelationshipSchema of(Map<? extends RelationshipType, ? extends Map<String, RelationshipPropertySchema>> properties) {
        return new ImmutableRelationshipSchema(properties);
    }

    public static RelationshipSchema copyOf(RelationshipSchema instance) {
        if (instance instanceof ImmutableRelationshipSchema) {
            return (ImmutableRelationshipSchema)instance;
        }
        return new RelationshipSchema.Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="RelationshipSchema", generator="Immutables")
    public static class Builder {
        protected Map<RelationshipType, Map<String, RelationshipPropertySchema>> properties = null;

        public Builder() {
            if (!(this instanceof RelationshipSchema.Builder)) {
                throw new UnsupportedOperationException("Use: new RelationshipSchema.Builder()");
            }
        }

        public final RelationshipSchema.Builder from(RelationshipSchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllProperties(instance.properties());
            return (RelationshipSchema.Builder)this;
        }

        public final RelationshipSchema.Builder putProperty(RelationshipType key, Map<String, RelationshipPropertySchema> value) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<RelationshipType, Map<String, RelationshipPropertySchema>>();
            }
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, "properties value"));
            return (RelationshipSchema.Builder)this;
        }

        public final RelationshipSchema.Builder putProperty(Map.Entry<? extends RelationshipType, ? extends Map<String, RelationshipPropertySchema>> entry) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<RelationshipType, Map<String, RelationshipPropertySchema>>();
            }
            RelationshipType k = entry.getKey();
            Map<String, RelationshipPropertySchema> v = entry.getValue();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            return (RelationshipSchema.Builder)this;
        }

        public final RelationshipSchema.Builder properties(Map<? extends RelationshipType, ? extends Map<String, RelationshipPropertySchema>> entries) {
            this.properties = new LinkedHashMap<RelationshipType, Map<String, RelationshipPropertySchema>>();
            return this.putAllProperties(entries);
        }

        public final RelationshipSchema.Builder putAllProperties(Map<? extends RelationshipType, ? extends Map<String, RelationshipPropertySchema>> entries) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<RelationshipType, Map<String, RelationshipPropertySchema>>();
            }
            for (Map.Entry<? extends RelationshipType, ? extends Map<String, RelationshipPropertySchema>> e : entries.entrySet()) {
                RelationshipType k = e.getKey();
                Map<String, RelationshipPropertySchema> v = e.getValue();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            }
            return (RelationshipSchema.Builder)this;
        }

        public RelationshipSchema.Builder clear() {
            if (this.properties != null) {
                this.properties.clear();
            }
            return (RelationshipSchema.Builder)this;
        }

        public RelationshipSchema build() {
            return new ImmutableRelationshipSchema(null, this.properties == null ? Collections.emptyMap() : ImmutableRelationshipSchema.createUnmodifiableMap(false, false, this.properties));
        }
    }

    @Generated(from="RelationshipSchema", generator="Immutables")
    private final class InitShim {
        private byte allPropertiesBuildStage = 0;
        private Set<String> allProperties;
        private byte hasPropertiesBuildStage = 0;
        private boolean hasProperties;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;

        private InitShim() {
        }

        Set<String> allProperties() {
            if (this.allPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allPropertiesBuildStage == 0) {
                this.allPropertiesBuildStage = (byte)-1;
                this.allProperties = Objects.requireNonNull(ImmutableRelationshipSchema.this.allPropertiesInitialize(), "allProperties");
                this.allPropertiesBuildStage = 1;
            }
            return this.allProperties;
        }

        boolean hasProperties() {
            if (this.hasPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasPropertiesBuildStage == 0) {
                this.hasPropertiesBuildStage = (byte)-1;
                this.hasProperties = ImmutableRelationshipSchema.this.hasPropertiesInitialize();
                this.hasPropertiesBuildStage = 1;
            }
            return this.hasProperties;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableRelationshipSchema.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.allPropertiesBuildStage == -1) {
                attributes.add("allProperties");
            }
            if (this.hasPropertiesBuildStage == -1) {
                attributes.add("hasProperties");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            return "Cannot build RelationshipSchema, attribute initializers form cycle " + attributes;
        }
    }
}

