/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.api.schema.PropertySchema;

@Generated(from="NodeSchema", generator="Immutables")
public final class ImmutableNodeSchema
implements NodeSchema {
    private final Map<NodeLabel, Map<String, PropertySchema>> properties;
    private final transient Set<String> allProperties;
    private final transient boolean hasProperties;
    private final transient Map<String, Object> toMap;
    private final transient Set<NodeLabel> availableLabels;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long UNION_PROPERTIES_LAZY_INIT_BIT = 1L;
    private transient Map<String, PropertySchema> unionProperties;

    private ImmutableNodeSchema(Map<? extends NodeLabel, ? extends Map<String, PropertySchema>> properties) {
        this.properties = ImmutableNodeSchema.createUnmodifiableMap(true, false, properties);
        this.allProperties = this.initShim.allProperties();
        this.hasProperties = this.initShim.hasProperties();
        this.toMap = this.initShim.toMap();
        this.availableLabels = this.initShim.availableLabels();
        this.initShim = null;
    }

    private ImmutableNodeSchema(ImmutableNodeSchema original, Map<NodeLabel, Map<String, PropertySchema>> properties) {
        this.properties = properties;
        this.allProperties = this.initShim.allProperties();
        this.hasProperties = this.initShim.hasProperties();
        this.toMap = this.initShim.toMap();
        this.availableLabels = this.initShim.availableLabels();
        this.initShim = null;
    }

    private Set<String> allPropertiesInitialize() {
        return NodeSchema.super.allProperties();
    }

    private boolean hasPropertiesInitialize() {
        return NodeSchema.super.hasProperties();
    }

    private Map<String, Object> toMapInitialize() {
        return NodeSchema.super.toMap();
    }

    private Set<NodeLabel> availableLabelsInitialize() {
        return NodeSchema.super.availableLabels();
    }

    @Override
    public Map<NodeLabel, Map<String, PropertySchema>> properties() {
        return this.properties;
    }

    @Override
    public Set<String> allProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allProperties() : this.allProperties;
    }

    @Override
    public boolean hasProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasProperties() : this.hasProperties;
    }

    @Override
    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    @Override
    public Set<NodeLabel> availableLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.availableLabels() : this.availableLabels;
    }

    public final ImmutableNodeSchema withProperties(Map<? extends NodeLabel, ? extends Map<String, PropertySchema>> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<NodeLabel, Map<String, PropertySchema>> newValue = ImmutableNodeSchema.createUnmodifiableMap(true, false, entries);
        return new ImmutableNodeSchema(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeSchema && this.equalTo((ImmutableNodeSchema)another);
    }

    private boolean equalTo(ImmutableNodeSchema another) {
        return this.properties.equals(another.properties) && this.allProperties.equals(another.allProperties) && this.hasProperties == another.hasProperties && this.toMap.equals(another.toMap) && this.availableLabels.equals(another.availableLabels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.allProperties.hashCode();
        h += (h << 5) + Boolean.hashCode(this.hasProperties);
        h += (h << 5) + this.toMap.hashCode();
        h += (h << 5) + this.availableLabels.hashCode();
        return h;
    }

    public String toString() {
        return "NodeSchema{properties=" + this.properties + ", allProperties=" + this.allProperties + ", hasProperties=" + this.hasProperties + ", toMap=" + this.toMap + ", availableLabels=" + this.availableLabels + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, PropertySchema> unionProperties() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableNodeSchema immutableNodeSchema = this;
            synchronized (immutableNodeSchema) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.unionProperties = Objects.requireNonNull(NodeSchema.super.unionProperties(), "unionProperties");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.unionProperties;
    }

    public static NodeSchema of(Map<? extends NodeLabel, ? extends Map<String, PropertySchema>> properties) {
        return new ImmutableNodeSchema(properties);
    }

    public static NodeSchema copyOf(NodeSchema instance) {
        if (instance instanceof ImmutableNodeSchema) {
            return (ImmutableNodeSchema)instance;
        }
        return new NodeSchema.Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="NodeSchema", generator="Immutables")
    public static class Builder {
        protected Map<NodeLabel, Map<String, PropertySchema>> properties = null;

        public Builder() {
            if (!(this instanceof NodeSchema.Builder)) {
                throw new UnsupportedOperationException("Use: new NodeSchema.Builder()");
            }
        }

        public final NodeSchema.Builder from(NodeSchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllProperties(instance.properties());
            return (NodeSchema.Builder)this;
        }

        public final NodeSchema.Builder putProperty(NodeLabel key, Map<String, PropertySchema> value) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<NodeLabel, Map<String, PropertySchema>>();
            }
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, "properties value"));
            return (NodeSchema.Builder)this;
        }

        public final NodeSchema.Builder putProperty(Map.Entry<? extends NodeLabel, ? extends Map<String, PropertySchema>> entry) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<NodeLabel, Map<String, PropertySchema>>();
            }
            NodeLabel k = entry.getKey();
            Map<String, PropertySchema> v = entry.getValue();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            return (NodeSchema.Builder)this;
        }

        public final NodeSchema.Builder properties(Map<? extends NodeLabel, ? extends Map<String, PropertySchema>> entries) {
            this.properties = new LinkedHashMap<NodeLabel, Map<String, PropertySchema>>();
            return this.putAllProperties(entries);
        }

        public final NodeSchema.Builder putAllProperties(Map<? extends NodeLabel, ? extends Map<String, PropertySchema>> entries) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<NodeLabel, Map<String, PropertySchema>>();
            }
            for (Map.Entry<? extends NodeLabel, ? extends Map<String, PropertySchema>> e : entries.entrySet()) {
                NodeLabel k = e.getKey();
                Map<String, PropertySchema> v = e.getValue();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            }
            return (NodeSchema.Builder)this;
        }

        public NodeSchema.Builder clear() {
            if (this.properties != null) {
                this.properties.clear();
            }
            return (NodeSchema.Builder)this;
        }

        public NodeSchema build() {
            return new ImmutableNodeSchema(null, this.properties == null ? Collections.emptyMap() : ImmutableNodeSchema.createUnmodifiableMap(false, false, this.properties));
        }
    }

    @Generated(from="NodeSchema", generator="Immutables")
    private final class InitShim {
        private byte allPropertiesBuildStage = 0;
        private Set<String> allProperties;
        private byte hasPropertiesBuildStage = 0;
        private boolean hasProperties;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte availableLabelsBuildStage = 0;
        private Set<NodeLabel> availableLabels;

        private InitShim() {
        }

        Set<String> allProperties() {
            if (this.allPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allPropertiesBuildStage == 0) {
                this.allPropertiesBuildStage = (byte)-1;
                this.allProperties = Objects.requireNonNull(ImmutableNodeSchema.this.allPropertiesInitialize(), "allProperties");
                this.allPropertiesBuildStage = 1;
            }
            return this.allProperties;
        }

        boolean hasProperties() {
            if (this.hasPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasPropertiesBuildStage == 0) {
                this.hasPropertiesBuildStage = (byte)-1;
                this.hasProperties = ImmutableNodeSchema.this.hasPropertiesInitialize();
                this.hasPropertiesBuildStage = 1;
            }
            return this.hasProperties;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableNodeSchema.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        Set<NodeLabel> availableLabels() {
            if (this.availableLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.availableLabelsBuildStage == 0) {
                this.availableLabelsBuildStage = (byte)-1;
                this.availableLabels = Objects.requireNonNull(ImmutableNodeSchema.this.availableLabelsInitialize(), "availableLabels");
                this.availableLabelsBuildStage = 1;
            }
            return this.availableLabels;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.allPropertiesBuildStage == -1) {
                attributes.add("allProperties");
            }
            if (this.hasPropertiesBuildStage == -1) {
                attributes.add("hasProperties");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.availableLabelsBuildStage == -1) {
                attributes.add("availableLabels");
            }
            return "Cannot build NodeSchema, attribute initializers form cycle " + attributes;
        }
    }
}

