/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.springframework.boot.autoconfigure;

import java.util.Map;
import org.neo4j.driver.Driver;
import org.neo4j.driver.springframework.boot.actuate.Neo4jHealthIndicator;
import org.neo4j.driver.springframework.boot.actuate.Neo4jReactiveHealthIndicator;
import org.neo4j.driver.springframework.boot.autoconfigure.Neo4jDriverAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthContributorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.neo4j.Neo4jHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jDataAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Driver.class, Health.class})
@ConditionalOnEnabledHealthIndicator(value="neo4j")
@AutoConfigureBefore(value={HealthContributorAutoConfiguration.class})
@AutoConfigureAfter(value={Neo4jDriverAutoConfiguration.class, Neo4jDataAutoConfiguration.class, Neo4jHealthContributorAutoConfiguration.class})
@ConditionalOnBean(value={Driver.class})
public class Neo4jDriverHealthContributorAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Flux.class})
    @Order(value=-30)
    static class Neo4jReactiveHealthIndicatorConfiguration
    extends CompositeReactiveHealthContributorConfiguration<Neo4jReactiveHealthIndicator, Driver> {
        Neo4jReactiveHealthIndicatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"neo4jHealthContributor"})
        public ReactiveHealthContributor neo4jHealthContributor(Map<String, Driver> drivers) {
            return this.createComposite(drivers);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Order(value=-20)
    static class Neo4jHealthIndicatorConfiguration
    extends CompositeHealthContributorConfiguration<Neo4jHealthIndicator, Driver> {
        Neo4jHealthIndicatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"neo4jHealthContributor"})
        public HealthContributor neo4jHealthContributor(Map<String, Driver> drivers) {
            return (HealthContributor)this.createContributor(drivers);
        }
    }
}

