/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.springframework.boot.actuate;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.springframework.boot.actuate.ResultSummaryWithEdition;
import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.ServerInfo;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.StringUtils;

public final class Neo4jHealthIndicator
extends AbstractHealthIndicator {
    private static final Log logger = LogFactory.getLog(Neo4jHealthIndicator.class);
    static final String CYPHER = "CALL dbms.components() YIELD name, edition WHERE name = 'Neo4j Kernel' RETURN edition";
    static final String MESSAGE_HEALTH_CHECK_FAILED = "Neo4j health check failed";
    static final String MESSAGE_SESSION_EXPIRED = "Neo4j session has expired, retrying one single time to retrieve server health.";
    static final SessionConfig DEFAULT_SESSION_CONFIG = SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE).build();
    private final Driver driver;

    public Neo4jHealthIndicator(Driver driver) {
        super(MESSAGE_HEALTH_CHECK_FAILED);
        this.driver = driver;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            ResultSummaryWithEdition resultSummaryWithEdition;
            try {
                resultSummaryWithEdition = this.runHealthCheckQuery();
            }
            catch (SessionExpiredException sessionExpiredException) {
                logger.warn((Object)MESSAGE_SESSION_EXPIRED);
                resultSummaryWithEdition = this.runHealthCheckQuery();
            }
            Neo4jHealthIndicator.buildStatusUp(resultSummaryWithEdition, builder);
        }
        catch (Exception ex) {
            builder.down().withException((Throwable)ex);
        }
    }

    static Health.Builder buildStatusUp(ResultSummaryWithEdition resultSummaryWithEdition, Health.Builder builder) {
        ServerInfo serverInfo = resultSummaryWithEdition.resultSummary.server();
        DatabaseInfo databaseInfo = resultSummaryWithEdition.resultSummary.database();
        builder.up().withDetail("server", (Object)(serverInfo.version() + "@" + serverInfo.address())).withDetail("edition", (Object)resultSummaryWithEdition.edition);
        if (StringUtils.hasText((String)databaseInfo.name())) {
            builder.withDetail("database", (Object)databaseInfo.name());
        }
        return builder;
    }

    ResultSummaryWithEdition runHealthCheckQuery() {
        try (Session session = this.driver.session(DEFAULT_SESSION_CONFIG);){
            ResultSummaryWithEdition resultSummaryWithEdition = (ResultSummaryWithEdition)session.writeTransaction(tx -> {
                Result result = tx.run(CYPHER);
                String edition = result.single().get("edition").asString();
                ResultSummary resultSummary = result.consume();
                return new ResultSummaryWithEdition(resultSummary, edition);
            });
            return resultSummaryWithEdition;
        }
    }
}

