/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.net.URI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.UriInfo;
import org.neo4j.server.web.XForwardUtil;

@PreMatching
public class XForwardFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) {
        String xForwardedHost = requestContext.getHeaderString("X-Forwarded-Host");
        String xForwardedProto = requestContext.getHeaderString("X-Forwarded-Proto");
        UriInfo uriInfo = requestContext.getUriInfo();
        URI externalBaseUri = XForwardUtil.externalUri(uriInfo.getBaseUri(), xForwardedHost, xForwardedProto);
        URI externalRequestUri = XForwardUtil.externalUri(uriInfo.getRequestUri(), xForwardedHost, xForwardedProto);
        requestContext.setRequestUri(externalBaseUri, externalRequestUri);
    }
}

