/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.blas;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.openblas.global.openblas_nolapack;
import org.nd4j.linalg.api.blas.impl.BaseLevel3;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.nd4j.linalg.api.ops.aggregates.impl.AggregateGEMM;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuBlas;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.Nd4jBlas;

public class CpuLevel3
extends BaseLevel3 {
    private Nd4jBlas nd4jBlas = (Nd4jBlas)Nd4j.factory().blas();

    protected void hgemm(char Order, char TransA, char TransB, int M, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        INDArray fA = A.castTo(DataType.FLOAT);
        INDArray fB = B.castTo(DataType.FLOAT);
        INDArray fC = C.castTo(DataType.FLOAT);
        this.sgemm(Order, TransA, TransB, M, N, K, alpha, fA, lda, fB, ldb, beta, fC, ldc);
        C.assign(fC);
    }

    protected void sgemm(char Order, char TransA, char TransB, int M, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        if (!Nd4j.isFallbackModeEnabled()) {
            openblas_nolapack.cblas_sgemm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertTranspose(TransA), (int)CpuBlas.convertTranspose(TransB), (int)M, (int)N, (int)K, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (FloatPointer)((FloatPointer)B.data().addressPointer()), (int)ldb, (float)beta, (FloatPointer)((FloatPointer)C.data().addressPointer()), (int)ldc);
        } else {
            Nd4j.getExecutioner().exec((Aggregate)new AggregateGEMM(102, (int)TransA, (int)TransB, M, N, K, (double)alpha, A, lda, B, ldb, (double)beta, C, ldc));
        }
    }

    protected void ssymm(char Order, char Side, char Uplo, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        openblas_nolapack.cblas_ssymm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)M, (int)N, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (FloatPointer)((FloatPointer)B.data().addressPointer()), (int)ldb, (float)beta, (FloatPointer)((FloatPointer)C.data().addressPointer()), (int)ldc);
    }

    protected void ssyrk(char Order, char Uplo, char Trans, int N, int K, float alpha, INDArray A, int lda, float beta, INDArray C, int ldc) {
        openblas_nolapack.cblas_ssyrk((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(Trans), (int)N, (int)K, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (float)beta, (FloatPointer)((FloatPointer)C.data().addressPointer()), (int)ldc);
    }

    protected void ssyr2k(char Order, char Uplo, char Trans, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        openblas_nolapack.cblas_ssyr2k((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(Trans), (int)N, (int)K, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (FloatPointer)((FloatPointer)B.data().addressPointer()), (int)ldb, (float)beta, (FloatPointer)((FloatPointer)C.data().addressPointer()), (int)ldc);
    }

    protected void strmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb) {
        openblas_nolapack.cblas_strmm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(TransA), (int)Diag, (int)M, (int)N, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (FloatPointer)((FloatPointer)B.data().addressPointer()), (int)ldb);
    }

    protected void strsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb) {
        openblas_nolapack.cblas_strsm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(TransA), (int)Diag, (int)M, (int)N, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (FloatPointer)((FloatPointer)B.data().addressPointer()), (int)ldb);
    }

    protected void dgemm(char Order, char TransA, char TransB, int M, int N, int K, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        if (!Nd4j.isFallbackModeEnabled()) {
            openblas_nolapack.cblas_dgemm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertTranspose(TransA), (int)CpuBlas.convertTranspose(TransB), (int)M, (int)N, (int)K, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (DoublePointer)((DoublePointer)B.data().addressPointer()), (int)ldb, (double)beta, (DoublePointer)((DoublePointer)C.data().addressPointer()), (int)ldc);
        } else {
            Nd4j.getExecutioner().exec((Aggregate)new AggregateGEMM(102, (int)TransA, (int)TransB, M, N, K, alpha, A, lda, B, ldb, beta, C, ldc));
        }
    }

    protected void dsymm(char Order, char Side, char Uplo, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        openblas_nolapack.cblas_dsymm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)M, (int)N, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (DoublePointer)((DoublePointer)B.data().addressPointer()), (int)ldb, (double)beta, (DoublePointer)((DoublePointer)C.data().addressPointer()), (int)ldc);
    }

    protected void dsyrk(char Order, char Uplo, char Trans, int N, int K, double alpha, INDArray A, int lda, double beta, INDArray C, int ldc) {
        openblas_nolapack.cblas_dsyrk((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(Trans), (int)N, (int)K, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (double)beta, (DoublePointer)((DoublePointer)C.data().addressPointer()), (int)ldc);
    }

    protected void dsyr2k(char Order, char Uplo, char Trans, int N, int K, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        openblas_nolapack.cblas_dsyr2k((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(Trans), (int)N, (int)K, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (DoublePointer)((DoublePointer)B.data().addressPointer()), (int)ldb, (double)beta, (DoublePointer)((DoublePointer)C.data().addressPointer()), (int)ldc);
    }

    protected void dtrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb) {
        openblas_nolapack.cblas_dtrmm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(TransA), (int)Diag, (int)M, (int)N, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (DoublePointer)((DoublePointer)B.data().addressPointer()), (int)ldb);
    }

    protected void dtrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb) {
        openblas_nolapack.cblas_dtrsm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(TransA), (int)Diag, (int)M, (int)N, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (DoublePointer)((DoublePointer)B.data().addressPointer()), (int)ldb);
    }
}

