/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientException;
import com.mongodb.MongoDriverInformation;
import com.mongodb.MongoInternalException;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.NettyMongoClients;
import com.mongodb.connection.AsynchronousSocketChannelStreamFactoryFactory;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.DefaultClusterFactory;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.TlsChannelStreamFactoryFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import org.bson.codecs.configuration.CodecRegistry;

@Deprecated
public final class MongoClients {
    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    @Deprecated
    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    @Deprecated
    public static MongoClient create(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(settings, mongoDriverInformation, null);
    }

    public static MongoClient create(ConnectionString connectionString, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(MongoClientSettings.builder().applyConnectionString(connectionString).build(), mongoDriverInformation, connectionString.getStreamType());
    }

    public static MongoClient create(com.mongodb.MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(com.mongodb.MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(MongoClientSettings.createFromClientSettings(settings), mongoDriverInformation, null);
    }

    private static MongoClient create(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, @Nullable String requestedStreamType) {
        String streamType = MongoClients.getStreamType(requestedStreamType);
        if (settings.getStreamFactoryFactory() == null) {
            if (MongoClients.isNetty(streamType)) {
                return NettyMongoClients.create(settings, mongoDriverInformation);
            }
            if (MongoClients.isNio(streamType)) {
                if (settings.getSslSettings().isEnabled()) {
                    return MongoClients.createWithTlsChannel(settings, mongoDriverInformation);
                }
                return MongoClients.createWithAsynchronousSocketChannel(settings, mongoDriverInformation);
            }
            throw new IllegalArgumentException("Unsupported stream type: " + streamType);
        }
        return MongoClients.createMongoClient(settings, mongoDriverInformation, MongoClients.getStreamFactory(settings, false), MongoClients.getStreamFactory(settings, true), null);
    }

    static MongoClient createMongoClient(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable Closeable externalResourceCloser) {
        return new MongoClientImpl(settings, MongoClients.createCluster(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory), externalResourceCloser);
    }

    private static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory) {
        Assertions.notNull((String)"settings", (Object)settings);
        MongoDriverInformation.Builder builder = mongoDriverInformation == null ? MongoDriverInformation.builder() : MongoDriverInformation.builder((MongoDriverInformation)mongoDriverInformation);
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), streamFactory, heartbeatStreamFactory, settings.getCredentialList(), EventListenerHelper.getCommandListener(settings.getCommandListeners()), settings.getApplicationName(), builder.driverName("async").build(), settings.getCompressorList());
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return com.mongodb.MongoClientSettings.getDefaultCodecRegistry();
    }

    private static MongoClient createWithTlsChannel(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        if (!MongoClients.isJava8()) {
            throw new MongoClientException("TLS is only supported natively with Java 8 and above. Please use Netty instead");
        }
        final TlsChannelStreamFactoryFactory streamFactoryFactory = new TlsChannelStreamFactoryFactory();
        StreamFactory streamFactory = streamFactoryFactory.create(settings.getSocketSettings(), settings.getSslSettings());
        StreamFactory heartbeatStreamFactory = streamFactoryFactory.create(settings.getHeartbeatSocketSettings(), settings.getSslSettings());
        return MongoClients.createMongoClient(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory, new Closeable(){

            @Override
            public void close() {
                streamFactoryFactory.close();
            }
        });
    }

    private static boolean isJava8() {
        try {
            Class.forName("java.time.Instant");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static MongoClient createWithAsynchronousSocketChannel(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        AsynchronousSocketChannelStreamFactoryFactory streamFactoryFactory = new AsynchronousSocketChannelStreamFactoryFactory();
        StreamFactory streamFactory = streamFactoryFactory.create(settings.getSocketSettings(), settings.getSslSettings());
        StreamFactory heartbeatStreamFactory = streamFactoryFactory.create(settings.getHeartbeatSocketSettings(), settings.getSslSettings());
        return MongoClients.createMongoClient(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory, null);
    }

    private static StreamFactory getStreamFactory(MongoClientSettings settings, boolean isHeartbeat) {
        StreamFactoryFactory streamFactoryFactory = settings.getStreamFactoryFactory();
        if (streamFactoryFactory == null) {
            throw new MongoInternalException("should not happen");
        }
        return streamFactoryFactory.create(isHeartbeat ? settings.getHeartbeatSocketSettings() : settings.getSocketSettings(), settings.getSslSettings());
    }

    private static boolean isNetty(String streamType) {
        return streamType.toLowerCase().equals("netty");
    }

    private static boolean isNio(String streamType) {
        return streamType.toLowerCase().equals("nio2");
    }

    private static String getStreamType(@Nullable String requestedStreamType) {
        if (requestedStreamType != null) {
            return requestedStreamType;
        }
        return System.getProperty("org.mongodb.async.type", "nio2");
    }

    private MongoClients() {
    }
}

