/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryHostPointerPropertiesEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYTYPEBITS;

    public VkMemoryHostPointerPropertiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryHostPointerPropertiesEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryHostPointerPropertiesEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkMemoryHostPointerPropertiesEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VkMemoryHostPointerPropertiesEXT.nmemoryTypeBits(this.address());
    }

    public VkMemoryHostPointerPropertiesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryHostPointerPropertiesEXT.nsType(this.address(), value);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT pNext(@NativeType(value="void *") long value) {
        VkMemoryHostPointerPropertiesEXT.npNext(this.address(), value);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT set(VkMemoryHostPointerPropertiesEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryHostPointerPropertiesEXT malloc() {
        return (VkMemoryHostPointerPropertiesEXT)VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkMemoryHostPointerPropertiesEXT calloc() {
        return (VkMemoryHostPointerPropertiesEXT)VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkMemoryHostPointerPropertiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkMemoryHostPointerPropertiesEXT)VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkMemoryHostPointerPropertiesEXT create(long address) {
        return (VkMemoryHostPointerPropertiesEXT)VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, (long)address);
    }

    @Nullable
    public static VkMemoryHostPointerPropertiesEXT createSafe(long address) {
        return address == 0L ? null : (VkMemoryHostPointerPropertiesEXT)VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkMemoryHostPointerPropertiesEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryHostPointerPropertiesEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkMemoryHostPointerPropertiesEXT mallocStack() {
        return VkMemoryHostPointerPropertiesEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryHostPointerPropertiesEXT callocStack() {
        return VkMemoryHostPointerPropertiesEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryHostPointerPropertiesEXT mallocStack(MemoryStack stack) {
        return (VkMemoryHostPointerPropertiesEXT)VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryHostPointerPropertiesEXT callocStack(MemoryStack stack) {
        return (VkMemoryHostPointerPropertiesEXT)VkMemoryHostPointerPropertiesEXT.wrap(VkMemoryHostPointerPropertiesEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryHostPointerPropertiesEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nmemoryTypeBits(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYTYPEBITS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkMemoryHostPointerPropertiesEXT.__struct((Struct.Member[])new Struct.Member[]{VkMemoryHostPointerPropertiesEXT.__member((int)4), VkMemoryHostPointerPropertiesEXT.__member((int)POINTER_SIZE), VkMemoryHostPointerPropertiesEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYTYPEBITS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryHostPointerPropertiesEXT, Buffer>
    implements NativeResource {
        private static final VkMemoryHostPointerPropertiesEXT ELEMENT_FACTORY = VkMemoryHostPointerPropertiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryHostPointerPropertiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryHostPointerPropertiesEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkMemoryHostPointerPropertiesEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VkMemoryHostPointerPropertiesEXT.nmemoryTypeBits(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryHostPointerPropertiesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryHostPointerPropertiesEXT.npNext(this.address(), value);
            return this;
        }
    }
}

