/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkGeometryAABBNV;
import org.lwjgl.vulkan.VkGeometryTrianglesNV;

public class VkGeometryDataNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRIANGLES;
    public static final int AABBS;

    public VkGeometryDataNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkGeometryDataNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkGeometryTrianglesNV triangles() {
        return VkGeometryDataNV.ntriangles(this.address());
    }

    public VkGeometryAABBNV aabbs() {
        return VkGeometryDataNV.naabbs(this.address());
    }

    public VkGeometryDataNV triangles(VkGeometryTrianglesNV value) {
        VkGeometryDataNV.ntriangles(this.address(), value);
        return this;
    }

    public VkGeometryDataNV triangles(Consumer<VkGeometryTrianglesNV> consumer) {
        consumer.accept(this.triangles());
        return this;
    }

    public VkGeometryDataNV aabbs(VkGeometryAABBNV value) {
        VkGeometryDataNV.naabbs(this.address(), value);
        return this;
    }

    public VkGeometryDataNV aabbs(Consumer<VkGeometryAABBNV> consumer) {
        consumer.accept(this.aabbs());
        return this;
    }

    public VkGeometryDataNV set(VkGeometryTrianglesNV triangles, VkGeometryAABBNV aabbs) {
        this.triangles(triangles);
        this.aabbs(aabbs);
        return this;
    }

    public VkGeometryDataNV set(VkGeometryDataNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkGeometryDataNV malloc() {
        return (VkGeometryDataNV)VkGeometryDataNV.wrap(VkGeometryDataNV.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkGeometryDataNV calloc() {
        return (VkGeometryDataNV)VkGeometryDataNV.wrap(VkGeometryDataNV.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkGeometryDataNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkGeometryDataNV)VkGeometryDataNV.wrap(VkGeometryDataNV.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkGeometryDataNV create(long address) {
        return (VkGeometryDataNV)VkGeometryDataNV.wrap(VkGeometryDataNV.class, (long)address);
    }

    @Nullable
    public static VkGeometryDataNV createSafe(long address) {
        return address == 0L ? null : (VkGeometryDataNV)VkGeometryDataNV.wrap(VkGeometryDataNV.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkGeometryDataNV.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkGeometryDataNV.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkGeometryDataNV.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkGeometryDataNV.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkGeometryDataNV.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkGeometryDataNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkGeometryDataNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkGeometryDataNV mallocStack() {
        return VkGeometryDataNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkGeometryDataNV callocStack() {
        return VkGeometryDataNV.callocStack(MemoryStack.stackGet());
    }

    public static VkGeometryDataNV mallocStack(MemoryStack stack) {
        return (VkGeometryDataNV)VkGeometryDataNV.wrap(VkGeometryDataNV.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkGeometryDataNV callocStack(MemoryStack stack) {
        return (VkGeometryDataNV)VkGeometryDataNV.wrap(VkGeometryDataNV.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkGeometryDataNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkGeometryDataNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkGeometryDataNV.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkGeometryDataNV.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkGeometryTrianglesNV ntriangles(long struct) {
        return VkGeometryTrianglesNV.create(struct + (long)TRIANGLES);
    }

    public static VkGeometryAABBNV naabbs(long struct) {
        return VkGeometryAABBNV.create(struct + (long)AABBS);
    }

    public static void ntriangles(long struct, VkGeometryTrianglesNV value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TRIANGLES), (long)VkGeometryTrianglesNV.SIZEOF);
    }

    public static void naabbs(long struct, VkGeometryAABBNV value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)AABBS), (long)VkGeometryAABBNV.SIZEOF);
    }

    static {
        Struct.Layout layout = VkGeometryDataNV.__struct((Struct.Member[])new Struct.Member[]{VkGeometryDataNV.__member((int)VkGeometryTrianglesNV.SIZEOF, (int)VkGeometryTrianglesNV.ALIGNOF), VkGeometryDataNV.__member((int)VkGeometryAABBNV.SIZEOF, (int)VkGeometryAABBNV.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRIANGLES = layout.offsetof(0);
        AABBS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkGeometryDataNV, Buffer>
    implements NativeResource {
        private static final VkGeometryDataNV ELEMENT_FACTORY = VkGeometryDataNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkGeometryDataNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkGeometryTrianglesNV triangles() {
            return VkGeometryDataNV.ntriangles(this.address());
        }

        public VkGeometryAABBNV aabbs() {
            return VkGeometryDataNV.naabbs(this.address());
        }

        public Buffer triangles(VkGeometryTrianglesNV value) {
            VkGeometryDataNV.ntriangles(this.address(), value);
            return this;
        }

        public Buffer triangles(Consumer<VkGeometryTrianglesNV> consumer) {
            consumer.accept(this.triangles());
            return this;
        }

        public Buffer aabbs(VkGeometryAABBNV value) {
            VkGeometryDataNV.naabbs(this.address(), value);
            return this;
        }

        public Buffer aabbs(Consumer<VkGeometryAABBNV> consumer) {
            consumer.accept(this.aabbs());
            return this;
        }
    }
}

