/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExternalMemoryImageCreateInfo;

public class VkExternalMemoryImageCreateInfoKHR
extends VkExternalMemoryImageCreateInfo {
    public VkExternalMemoryImageCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryImageCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryImageCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryImageCreateInfoKHR.nhandleTypes(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryImageCreateInfoKHR set(VkExternalMemoryImageCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkExternalMemoryImageCreateInfoKHR malloc() {
        return (VkExternalMemoryImageCreateInfoKHR)VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoKHR calloc() {
        return (VkExternalMemoryImageCreateInfoKHR)VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkExternalMemoryImageCreateInfoKHR)VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkExternalMemoryImageCreateInfoKHR create(long address) {
        return (VkExternalMemoryImageCreateInfoKHR)VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkExternalMemoryImageCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkExternalMemoryImageCreateInfoKHR)VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkExternalMemoryImageCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalMemoryImageCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkExternalMemoryImageCreateInfoKHR mallocStack() {
        return VkExternalMemoryImageCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryImageCreateInfoKHR callocStack() {
        return VkExternalMemoryImageCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryImageCreateInfoKHR mallocStack(MemoryStack stack) {
        return (VkExternalMemoryImageCreateInfoKHR)VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoKHR callocStack(MemoryStack stack) {
        return (VkExternalMemoryImageCreateInfoKHR)VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryImageCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryImageCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkExternalMemoryImageCreateInfo.Buffer {
        private static final VkExternalMemoryImageCreateInfoKHR ELEMENT_FACTORY = VkExternalMemoryImageCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExternalMemoryImageCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryImageCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryImageCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryImageCreateInfoKHR.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

