/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.util.Map;
import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkImageViewHandleInfoNVX;

public class NVXImageViewHandle {
    public static final int VK_NVX_IMAGE_VIEW_HANDLE_SPEC_VERSION = 1;
    public static final String VK_NVX_IMAGE_VIEW_HANDLE_EXTENSION_NAME = "VK_NVX_image_view_handle";
    public static final int VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX = 1000030000;

    protected NVXImageViewHandle() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_NVX_IMAGE_VIEW_HANDLE_EXTENSION_NAME) && VK.checkExtension(VK_NVX_IMAGE_VIEW_HANDLE_EXTENSION_NAME, VK.isSupported(provider, "vkGetImageViewHandleNVX", caps));
    }

    public static int nvkGetImageViewHandleNVX(VkDevice device, long pInfo) {
        long __functionAddress = device.getCapabilities().vkGetImageViewHandleNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)device.address(), (long)pInfo, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int vkGetImageViewHandleNVX(VkDevice device, @NativeType(value="VkImageViewHandleInfoNVX const *") VkImageViewHandleInfoNVX pInfo) {
        return NVXImageViewHandle.nvkGetImageViewHandleNVX(device, pInfo.address());
    }
}

