/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import java.util.Map;
import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkInitializePerformanceApiInfoINTEL;
import org.lwjgl.vulkan.VkPerformanceConfigurationAcquireInfoINTEL;
import org.lwjgl.vulkan.VkPerformanceMarkerInfoINTEL;
import org.lwjgl.vulkan.VkPerformanceOverrideInfoINTEL;
import org.lwjgl.vulkan.VkPerformanceStreamMarkerInfoINTEL;
import org.lwjgl.vulkan.VkPerformanceValueINTEL;
import org.lwjgl.vulkan.VkQueue;

public class INTELPerformanceQuery {
    public static final int VK_INTEL_PERFORMANCE_QUERY_SPEC_VERSION = 1;
    public static final String VK_INTEL_PERFORMANCE_QUERY_EXTENSION_NAME = "VK_INTEL_performance_query";
    public static final int VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO_INTEL = 1000210000;
    public static final int VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL = 1000210001;
    public static final int VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL = 1000210002;
    public static final int VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL = 1000210003;
    public static final int VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL = 1000210004;
    public static final int VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL = 1000210005;
    public static final int VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL = 1000210000;
    public static final int VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL = 1000210000;
    public static final int VK_PERFORMANCE_CONFIGURATION_TYPE_COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED_INTEL = 0;
    public static final int VK_QUERY_POOL_SAMPLING_MODE_MANUAL_INTEL = 0;
    public static final int VK_PERFORMANCE_OVERRIDE_TYPE_NULL_HARDWARE_INTEL = 0;
    public static final int VK_PERFORMANCE_OVERRIDE_TYPE_FLUSH_GPU_CACHES_INTEL = 1;
    public static final int VK_PERFORMANCE_PARAMETER_TYPE_HW_COUNTERS_SUPPORTED_INTEL = 0;
    public static final int VK_PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL = 1;
    public static final int VK_PERFORMANCE_VALUE_TYPE_UINT32_INTEL = 0;
    public static final int VK_PERFORMANCE_VALUE_TYPE_UINT64_INTEL = 1;
    public static final int VK_PERFORMANCE_VALUE_TYPE_FLOAT_INTEL = 2;
    public static final int VK_PERFORMANCE_VALUE_TYPE_BOOL_INTEL = 3;
    public static final int VK_PERFORMANCE_VALUE_TYPE_STRING_INTEL = 4;

    protected INTELPerformanceQuery() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_INTEL_PERFORMANCE_QUERY_EXTENSION_NAME) && VK.checkExtension(VK_INTEL_PERFORMANCE_QUERY_EXTENSION_NAME, VK.isSupported(provider, "vkInitializePerformanceApiINTEL", caps) && VK.isSupported(provider, "vkUninitializePerformanceApiINTEL", caps) && VK.isSupported(provider, "vkCmdSetPerformanceMarkerINTEL", caps) && VK.isSupported(provider, "vkCmdSetPerformanceStreamMarkerINTEL", caps) && VK.isSupported(provider, "vkCmdSetPerformanceOverrideINTEL", caps) && VK.isSupported(provider, "vkAcquirePerformanceConfigurationINTEL", caps) && VK.isSupported(provider, "vkReleasePerformanceConfigurationINTEL", caps) && VK.isSupported(provider, "vkQueueSetPerformanceConfigurationINTEL", caps) && VK.isSupported(provider, "vkGetPerformanceParameterINTEL", caps));
    }

    public static int nvkInitializePerformanceApiINTEL(VkDevice device, long pInitializeInfo) {
        long __functionAddress = device.getCapabilities().vkInitializePerformanceApiINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)device.address(), (long)pInitializeInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkInitializePerformanceApiINTEL(VkDevice device, @NativeType(value="VkInitializePerformanceApiInfoINTEL const *") VkInitializePerformanceApiInfoINTEL pInitializeInfo) {
        return INTELPerformanceQuery.nvkInitializePerformanceApiINTEL(device, pInitializeInfo.address());
    }

    public static void vkUninitializePerformanceApiINTEL(VkDevice device) {
        long __functionAddress = device.getCapabilities().vkUninitializePerformanceApiINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)device.address(), (long)__functionAddress);
    }

    public static int nvkCmdSetPerformanceMarkerINTEL(VkCommandBuffer commandBuffer, long pMarkerInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetPerformanceMarkerINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)commandBuffer.address(), (long)pMarkerInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCmdSetPerformanceMarkerINTEL(VkCommandBuffer commandBuffer, @NativeType(value="VkPerformanceMarkerInfoINTEL const *") VkPerformanceMarkerInfoINTEL pMarkerInfo) {
        return INTELPerformanceQuery.nvkCmdSetPerformanceMarkerINTEL(commandBuffer, pMarkerInfo.address());
    }

    public static int nvkCmdSetPerformanceStreamMarkerINTEL(VkCommandBuffer commandBuffer, long pMarkerInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetPerformanceStreamMarkerINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)commandBuffer.address(), (long)pMarkerInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCmdSetPerformanceStreamMarkerINTEL(VkCommandBuffer commandBuffer, @NativeType(value="VkPerformanceStreamMarkerInfoINTEL const *") VkPerformanceStreamMarkerInfoINTEL pMarkerInfo) {
        return INTELPerformanceQuery.nvkCmdSetPerformanceStreamMarkerINTEL(commandBuffer, pMarkerInfo.address());
    }

    public static int nvkCmdSetPerformanceOverrideINTEL(VkCommandBuffer commandBuffer, long pOverrideInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetPerformanceOverrideINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)commandBuffer.address(), (long)pOverrideInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCmdSetPerformanceOverrideINTEL(VkCommandBuffer commandBuffer, @NativeType(value="VkPerformanceOverrideInfoINTEL const *") VkPerformanceOverrideInfoINTEL pOverrideInfo) {
        return INTELPerformanceQuery.nvkCmdSetPerformanceOverrideINTEL(commandBuffer, pOverrideInfo.address());
    }

    public static int nvkAcquirePerformanceConfigurationINTEL(VkDevice device, long pAcquireInfo, long pConfiguration) {
        long __functionAddress = device.getCapabilities().vkAcquirePerformanceConfigurationINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)device.address(), (long)pAcquireInfo, (long)pConfiguration, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkAcquirePerformanceConfigurationINTEL(VkDevice device, @NativeType(value="VkPerformanceConfigurationAcquireInfoINTEL const *") VkPerformanceConfigurationAcquireInfoINTEL pAcquireInfo, @NativeType(value="VkPerformanceConfigurationINTEL *") LongBuffer pConfiguration) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pConfiguration, (int)1);
        }
        return INTELPerformanceQuery.nvkAcquirePerformanceConfigurationINTEL(device, pAcquireInfo.address(), MemoryUtil.memAddress((LongBuffer)pConfiguration));
    }

    @NativeType(value="VkResult")
    public static int vkReleasePerformanceConfigurationINTEL(VkDevice device, @NativeType(value="VkPerformanceConfigurationINTEL") long configuration) {
        long __functionAddress = device.getCapabilities().vkReleasePerformanceConfigurationINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJI((long)device.address(), (long)configuration, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkQueueSetPerformanceConfigurationINTEL(VkQueue queue, @NativeType(value="VkPerformanceConfigurationINTEL") long configuration) {
        long __functionAddress = queue.getCapabilities().vkQueueSetPerformanceConfigurationINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJI((long)queue.address(), (long)configuration, (long)__functionAddress);
    }

    public static int nvkGetPerformanceParameterINTEL(VkDevice device, int parameter, long pValue) {
        long __functionAddress = device.getCapabilities().vkGetPerformanceParameterINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)device.address(), (int)parameter, (long)pValue, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPerformanceParameterINTEL(VkDevice device, @NativeType(value="VkPerformanceParameterTypeINTEL") int parameter, @NativeType(value="VkPerformanceValueINTEL *") VkPerformanceValueINTEL pValue) {
        return INTELPerformanceQuery.nvkGetPerformanceParameterINTEL(device, parameter, pValue.address());
    }

    @NativeType(value="VkResult")
    public static int vkAcquirePerformanceConfigurationINTEL(VkDevice device, @NativeType(value="VkPerformanceConfigurationAcquireInfoINTEL const *") VkPerformanceConfigurationAcquireInfoINTEL pAcquireInfo, @NativeType(value="VkPerformanceConfigurationINTEL *") long[] pConfiguration) {
        long __functionAddress = device.getCapabilities().vkAcquirePerformanceConfigurationINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pConfiguration, (int)1);
        }
        return JNI.callPPPI((long)device.address(), (long)pAcquireInfo.address(), (long[])pConfiguration, (long)__functionAddress);
    }
}

