/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPoseStatef;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrTrackingState")
public class OVRTrackingState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADPOSE;
    public static final int STATUSFLAGS;
    public static final int HANDPOSES;
    public static final int HANDSTATUSFLAGS;
    public static final int CALIBRATEDORIGIN;

    public OVRTrackingState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRTrackingState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrPoseStatef")
    public OVRPoseStatef HeadPose() {
        return OVRTrackingState.nHeadPose(this.address());
    }

    @NativeType(value="unsigned int")
    public int StatusFlags() {
        return OVRTrackingState.nStatusFlags(this.address());
    }

    @NativeType(value="ovrPoseStatef[2]")
    public OVRPoseStatef.Buffer HandPoses() {
        return OVRTrackingState.nHandPoses(this.address());
    }

    @NativeType(value="ovrPoseStatef")
    public OVRPoseStatef HandPoses(int index) {
        return OVRTrackingState.nHandPoses(this.address(), index);
    }

    @NativeType(value="unsigned int[2]")
    public IntBuffer HandStatusFlags() {
        return OVRTrackingState.nHandStatusFlags(this.address());
    }

    @NativeType(value="unsigned int")
    public int HandStatusFlags(int index) {
        return OVRTrackingState.nHandStatusFlags(this.address(), index);
    }

    @NativeType(value="ovrPosef")
    public OVRPosef CalibratedOrigin() {
        return OVRTrackingState.nCalibratedOrigin(this.address());
    }

    public static OVRTrackingState malloc() {
        return (OVRTrackingState)OVRTrackingState.wrap(OVRTrackingState.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRTrackingState calloc() {
        return (OVRTrackingState)OVRTrackingState.wrap(OVRTrackingState.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRTrackingState create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRTrackingState)OVRTrackingState.wrap(OVRTrackingState.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRTrackingState create(long address) {
        return (OVRTrackingState)OVRTrackingState.wrap(OVRTrackingState.class, (long)address);
    }

    @Nullable
    public static OVRTrackingState createSafe(long address) {
        return address == 0L ? null : (OVRTrackingState)OVRTrackingState.wrap(OVRTrackingState.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRTrackingState.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRTrackingState.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRTrackingState.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRTrackingState.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRTrackingState.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRTrackingState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRTrackingState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OVRTrackingState mallocStack() {
        return OVRTrackingState.mallocStack(MemoryStack.stackGet());
    }

    public static OVRTrackingState callocStack() {
        return OVRTrackingState.callocStack(MemoryStack.stackGet());
    }

    public static OVRTrackingState mallocStack(MemoryStack stack) {
        return (OVRTrackingState)OVRTrackingState.wrap(OVRTrackingState.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRTrackingState callocStack(MemoryStack stack) {
        return (OVRTrackingState)OVRTrackingState.wrap(OVRTrackingState.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRTrackingState.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRTrackingState.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRTrackingState.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRTrackingState.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static OVRPoseStatef nHeadPose(long struct) {
        return OVRPoseStatef.create(struct + (long)HEADPOSE);
    }

    public static int nStatusFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)STATUSFLAGS);
    }

    public static OVRPoseStatef.Buffer nHandPoses(long struct) {
        return OVRPoseStatef.create(struct + (long)HANDPOSES, 2);
    }

    public static OVRPoseStatef nHandPoses(long struct, int index) {
        return OVRPoseStatef.create(struct + (long)HANDPOSES + Checks.check((int)index, (int)2) * (long)OVRPoseStatef.SIZEOF);
    }

    public static IntBuffer nHandStatusFlags(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)HANDSTATUSFLAGS), (int)2);
    }

    public static int nHandStatusFlags(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)HANDSTATUSFLAGS + Checks.check((int)index, (int)2) * 4L);
    }

    public static OVRPosef nCalibratedOrigin(long struct) {
        return OVRPosef.create(struct + (long)CALIBRATEDORIGIN);
    }

    static {
        Struct.Layout layout = OVRTrackingState.__struct((Struct.Member[])new Struct.Member[]{OVRTrackingState.__member((int)OVRPoseStatef.SIZEOF, (int)OVRPoseStatef.ALIGNOF), OVRTrackingState.__member((int)4), OVRTrackingState.__array((int)OVRPoseStatef.SIZEOF, (int)OVRPoseStatef.ALIGNOF, (int)2), OVRTrackingState.__array((int)4, (int)2), OVRTrackingState.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADPOSE = layout.offsetof(0);
        STATUSFLAGS = layout.offsetof(1);
        HANDPOSES = layout.offsetof(2);
        HANDSTATUSFLAGS = layout.offsetof(3);
        CALIBRATEDORIGIN = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<OVRTrackingState, Buffer>
    implements NativeResource {
        private static final OVRTrackingState ELEMENT_FACTORY = OVRTrackingState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRTrackingState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrPoseStatef")
        public OVRPoseStatef HeadPose() {
            return OVRTrackingState.nHeadPose(this.address());
        }

        @NativeType(value="unsigned int")
        public int StatusFlags() {
            return OVRTrackingState.nStatusFlags(this.address());
        }

        @NativeType(value="ovrPoseStatef[2]")
        public OVRPoseStatef.Buffer HandPoses() {
            return OVRTrackingState.nHandPoses(this.address());
        }

        @NativeType(value="ovrPoseStatef")
        public OVRPoseStatef HandPoses(int index) {
            return OVRTrackingState.nHandPoses(this.address(), index);
        }

        @NativeType(value="unsigned int[2]")
        public IntBuffer HandStatusFlags() {
            return OVRTrackingState.nHandStatusFlags(this.address());
        }

        @NativeType(value="unsigned int")
        public int HandStatusFlags(int index) {
            return OVRTrackingState.nHandStatusFlags(this.address(), index);
        }

        @NativeType(value="ovrPosef")
        public OVRPosef CalibratedOrigin() {
            return OVRTrackingState.nCalibratedOrigin(this.address());
        }
    }
}

