/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import liquibase.Liquibase;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.exception.CommandExecutionException;
import liquibase.util.StringUtil;
import org.liquibase.maven.plugins.AbstractLiquibaseChecksMojo;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseChecksRunMojo
extends AbstractLiquibaseChecksMojo {
    @PropertyElement
    protected String changeLogFile;
    @PropertyElement
    protected String format;
    @PropertyElement
    protected String checksScope;
    @PropertyElement
    protected String autoUpdate;
    @PropertyElement
    protected String checkName;
    @PropertyElement
    protected String username;
    @PropertyElement
    protected String password;
    @PropertyElement
    protected String url;
    @PropertyElement
    protected String schemas;
    @PropertyElement
    protected String defaultSchemaName;
    @PropertyElement
    protected String defaultCatalogName;
    @PropertyElement
    protected String driver;
    @PropertyElement
    protected String driverPropertiesFile;
    @PropertyElement
    protected File outputFile;

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws CommandExecutionException {
        CommandScope liquibaseCommand = new CommandScope(new String[]{"checks", "run"});
        this.addArgumentIfNotEmpty(liquibaseCommand, this.changeLogFile, CommonArgumentNames.CHANGELOG_FILE.getArgumentName());
        this.addArgumentIfNotEmpty(liquibaseCommand, this.checksSettingsFile, "checksSettingsFile");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.format, "format");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.checksScope, "checksScope");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.autoUpdate, "autoUpdate");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.checkName, "checkName");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.username, "username");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.password, "password");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.url, "url");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.schemas, "schemas");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.defaultSchemaName, "defaultSchemaName");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.defaultCatalogName, "defaultCatalogName");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.driver, "driver");
        this.addArgumentIfNotEmpty(liquibaseCommand, this.driverPropertiesFile, "driverPropertiesFile");
        if (this.outputFile != null) {
            try {
                liquibaseCommand.setOutput((OutputStream)new FileOutputStream(this.outputFile));
            }
            catch (FileNotFoundException e) {
                throw new CommandExecutionException((Throwable)e);
            }
        }
        liquibaseCommand.addArgumentValue("checksIntegration", (Object)"maven");
        liquibaseCommand.execute();
    }

    private void addArgumentIfNotEmpty(CommandScope commandScope, String argument, String name) {
        if (StringUtil.isNotEmpty((String)argument)) {
            commandScope.addArgumentValue(name, (Object)argument);
        }
    }
}

