/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbSearcher;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.StringUtils;

public class Ip2regionSearcher
implements DisposableBean {
    private ThreadLocal<String> threadLocal = new ThreadLocal();
    private DbSearcher dbSearcher;

    public Ip2regionSearcher(DbSearcher dbSearcher) {
        this.dbSearcher = dbSearcher;
    }

    public synchronized Ip2regionSearcher search(String ip) throws IOException {
        return this.search(ip, ALGORITHM.BTREE_SEARCH);
    }

    public synchronized Ip2regionSearcher search(String ip, ALGORITHM algorithm) throws IOException {
        DataBlock dataBlock = null;
        switch (algorithm) {
            case BTREE_SEARCH: {
                dataBlock = this.dbSearcher.btreeSearch(ip);
                break;
            }
            case BINARY_SEARCH: {
                dataBlock = this.dbSearcher.binarySearch(ip);
                break;
            }
            case MEMORY_SEARCH: {
                dataBlock = this.dbSearcher.memorySearch(ip);
            }
        }
        if (dataBlock != null) {
            this.threadLocal.set(dataBlock.getRegion());
        }
        return this;
    }

    public String toString() {
        String d = this.threadLocal.get();
        if (StringUtils.isEmpty((Object)d)) {
            return "";
        }
        return d;
    }

    public String getCountry() {
        return this.getByIdx(0);
    }

    public String getRegion() {
        return this.getByIdx(1);
    }

    public String getProvince() {
        return this.getByIdx(2);
    }

    public String getCity() {
        return this.getByIdx(3);
    }

    public String getISP() {
        return this.getByIdx(4);
    }

    private String getByIdx(int i) {
        String d = this.threadLocal.get();
        if (StringUtils.isEmpty((Object)d)) {
            return "";
        }
        List<String> list = Arrays.asList(StringUtils.delimitedListToStringArray((String)d, (String)"|"));
        return list.get(i);
    }

    public void destroy() throws Exception {
        this.dbSearcher.close();
        this.dbSearcher = null;
    }

    public static enum ALGORITHM {
        BTREE_SEARCH,
        BINARY_SEARCH,
        MEMORY_SEARCH;

    }
}

