/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbMakerConfigException;
import org.lionsoul.ip2region.DbSearcher;
import org.lionsoul.ip2region.Ip2RegionProperties;
import org.lionsoul.ip2region.Ip2regionSearcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ResourceUtils;

@Configuration
@EnableConfigurationProperties(value={Ip2RegionProperties.class})
@ConditionalOnClass(value={DbSearcher.class})
public class Ip2RegionAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(Ip2RegionAutoConfiguration.class);
    public static final String IP2REGION_DBSEARCHER_BEAN_NAME = "ip2regionSearcher";

    @Bean(name={"ip2regionSearcher"})
    @ConditionalOnProperty(prefix="ip2region", name={"enabled"}, havingValue="true")
    public Ip2regionSearcher autoIp2regionSearcher(@Autowired Ip2RegionProperties properties) {
        try {
            File file = ResourceUtils.getFile((String)("classpath:" + properties.getDbfile()));
            return new Ip2regionSearcher(new DbSearcher(new DbConfig(), file.getAbsolutePath()));
        }
        catch (DbMakerConfigException file) {
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("Ip2regionSearcher can not find db file in the path [" + properties.getDbfile() + "]"));
        }
        return null;
    }
}

