/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.apache;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.ldaptive.AttributeModification;
import org.ldaptive.AttributeModificationType;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchEntry;
import org.ldaptive.SortBehavior;
import org.ldaptive.control.ResponseControl;

public class ApacheLdapUtils {
    private final SortBehavior sortBehavior;
    private List<String> binaryAttrs;

    public ApacheLdapUtils() {
        this.sortBehavior = SortBehavior.getDefaultSortBehavior();
    }

    public ApacheLdapUtils(SortBehavior sb) {
        this.sortBehavior = sb;
    }

    public List<String> getBinaryAttributes() {
        return this.binaryAttrs;
    }

    public void setBinaryAttributes(String[] s) {
        if (s != null) {
            this.binaryAttrs = Arrays.asList(s);
        }
    }

    public static Value<?> createValue(Object o) {
        if (o instanceof String) {
            return new StringValue((String)o);
        }
        if (o instanceof byte[]) {
            return new BinaryValue((byte[])o);
        }
        throw new IllegalArgumentException("Unsupported attribute value type " + o.getClass());
    }

    public Attribute fromLdapAttribute(LdapAttribute la) {
        DefaultAttribute attribute = new DefaultAttribute(la.getName());
        if (la.isBinary()) {
            for (byte[] value : la.getBinaryValues()) {
                attribute.add(new Value[]{ApacheLdapUtils.createValue(value)});
            }
        } else {
            for (String value : la.getStringValues()) {
                attribute.add(new Value[]{ApacheLdapUtils.createValue(value)});
            }
        }
        return attribute;
    }

    public LdapAttribute toLdapAttribute(Attribute a) {
        boolean isBinary = false;
        if (a.getId().contains(";binary")) {
            isBinary = true;
        } else if (this.binaryAttrs != null && this.binaryAttrs.contains(a.getUpId())) {
            isBinary = true;
        }
        LdapAttribute la = new LdapAttribute(this.sortBehavior, isBinary);
        la.setName(a.getUpId());
        for (Value v : a) {
            if (isBinary) {
                la.addBinaryValue((byte[][])new byte[][]{v.getBytes()});
                continue;
            }
            la.addStringValue(new String[]{v.getString()});
        }
        return la;
    }

    public Attribute[] fromLdapAttributes(Collection<LdapAttribute> c) {
        return (Attribute[])c.stream().map(this::fromLdapAttribute).toArray(Attribute[]::new);
    }

    public Entry fromLdapEntry(LdapEntry le) throws LdapException {
        DefaultEntry entry = new DefaultEntry(le.getDn());
        entry.add(this.fromLdapAttributes(le.getAttributes()));
        return entry;
    }

    public SearchEntry toSearchEntry(Entry e, ResponseControl[] c, int id) {
        SearchEntry se = new SearchEntry(id, c, this.sortBehavior);
        se.setDn(e.getDn().getName());
        for (Attribute a : e) {
            se.addAttribute(new LdapAttribute[]{this.toLdapAttribute(a)});
        }
        return se;
    }

    public Modification[] fromAttributeModification(AttributeModification[] am) {
        Modification[] mods = new Modification[am.length];
        for (int i = 0; i < am.length; ++i) {
            mods[i] = new DefaultModification(ApacheLdapUtils.getAttributeModification(am[i].getAttributeModificationType()), this.fromLdapAttribute(am[i].getAttribute()));
        }
        return mods;
    }

    protected static ModificationOperation getAttributeModification(AttributeModificationType am) {
        ModificationOperation op = null;
        if (am == AttributeModificationType.ADD) {
            op = ModificationOperation.ADD_ATTRIBUTE;
        } else if (am == AttributeModificationType.REMOVE) {
            op = ModificationOperation.REMOVE_ATTRIBUTE;
        } else if (am == AttributeModificationType.REPLACE) {
            op = ModificationOperation.REPLACE_ATTRIBUTE;
        }
        return op;
    }
}

