/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.FileObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.AbstractProcessorImpl;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"*"})
public class QueryParameterAnnotationProcessor6
extends AbstractProcessorImpl {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            Set<? extends Element> params = roundEnv.getElementsAnnotatedWith(QueryParameter.class);
            HashSet<ExecutableElement> methods = new HashSet<ExecutableElement>();
            for (Element element : params) {
                methods.add((ExecutableElement)element.getEnclosingElement());
            }
            for (ExecutableElement executableElement : methods) {
                this.write(executableElement);
            }
        }
        catch (IOException e) {
            this.error(e.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(ExecutableElement m) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (VariableElement variableElement : m.getParameters()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(variableElement.getSimpleName());
        }
        TypeElement t = (TypeElement)m.getEnclosingElement();
        FileObject fileObject = this.createResource(t.getQualifiedName().toString().replace('.', '/') + "/" + m.getSimpleName() + ".stapler");
        this.notice("Generating " + fileObject, m);
        OutputStream os = fileObject.openOutputStream();
        try {
            IOUtils.write((StringBuffer)buf, (OutputStream)os, (String)"UTF-8");
        }
        finally {
            os.close();
        }
    }
}

