/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nProgress {
    private final Set<String> locales = new TreeSet<String>();
    private final List<HudsonMessages> messages = new ArrayList<HudsonMessages>();
    private static final String MESSAGES_FILE = "Messages.properties";
    private static final Pattern FILENAME_PATTERN = Pattern.compile("^Messages_?([a-zA-Z_]*)\\.properties$");

    public HudsonMessages getTotal() {
        HudsonMessages sum = new HudsonMessages(new File("total"));
        ArrayList<String> localesPlusOne = new ArrayList<String>(this.locales);
        localesPlusOne.add("");
        for (String locale : localesPlusOne) {
            int cnt = 0;
            for (HudsonMessages m : this.messages) {
                cnt += m.getCnt(locale);
            }
            sum.setCnt(locale, cnt);
        }
        return sum;
    }

    private int getMessageCnt(File file) {
        Properties props = new Properties();
        int cnt = 0;
        try {
            props.load(new FileInputStream(file));
            cnt = props.size();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cnt;
    }

    public String toHatena() {
        StringBuilder b = new StringBuilder();
        b.append("|*Messages(#)|");
        for (String locale : this.locales) {
            b.append("*").append(locale).append("|");
        }
        b.append("\n");
        for (HudsonMessages m : this.messages) {
            m.toHatena(b);
        }
        this.getTotal().toHatena(b);
        return b.toString();
    }

    public void parse(File dir) {
        File[] files;
        HudsonMessages m = new HudsonMessages(dir);
        for (File f : files = dir.listFiles()) {
            Matcher matcher = FILENAME_PATTERN.matcher(f.getName());
            if (!matcher.matches()) continue;
            String locale = matcher.group(1);
            if (!locale.equals("")) {
                this.locales.add(locale);
            }
            m.setCnt(locale, this.getMessageCnt(f));
        }
        this.messages.add(m);
    }

    public void parse(Collection<File> dirs) {
        for (File dir : dirs) {
            this.parse(dir);
        }
    }

    public void parseRecursively(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.parseRecursively(f);
                continue;
            }
            if (!f.isFile() || !MESSAGES_FILE.equals(f.getName())) continue;
            this.parse(f.getParentFile());
        }
    }

    public final class HudsonMessages {
        private final File dir;
        private final Map<String, Integer> map = new HashMap<String, Integer>();

        public HudsonMessages(File dir) {
            this.dir = dir;
        }

        public String getDirectoryName() {
            return this.dir.getName();
        }

        private void setCnt(String locale, int cnt) {
            this.map.put(locale, cnt);
        }

        public int getCnt(String locale) {
            Integer cnt = this.map.get(locale);
            return cnt != null ? cnt : 0;
        }

        public int ratio(String locale) {
            return (int)((double)this.getCnt(locale) / (double)this.getCnt("") * 100.0);
        }

        public void toHatena(StringBuilder b) {
            b.append("|").append(this.getDirectoryName()).append("(").append(this.getCnt("")).append(") |");
            for (String locale : L10nProgress.this.locales) {
                b.append(this.getCnt(locale)).append("(").append(this.ratio(locale)).append("%)|");
            }
            b.append("\n");
        }
    }
}

