/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.DockerConfiguration;
import org.jreleaser.model.internal.packagers.DockerPackager;
import org.jreleaser.model.internal.packagers.DockerSpec;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class DockerPackagerProcessor
extends AbstractRepositoryPackagerProcessor<DockerPackager> {
    private static final String ROOT = "ROOT";

    public DockerPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, TemplateContext props, String distributionName, Path prepareDirectory, String templateDirectory, String packagerName, boolean copyLicense) throws IOException, PackagerProcessingException {
        if (((DockerPackager)this.packager).getActiveSpecs().isEmpty()) {
            super.doPrepareDistribution(distribution, props, distributionName, prepareDirectory, templateDirectory, packagerName, true);
            if (!((DockerPackager)this.packager).isUseLocalArtifact()) {
                Files.move(prepareDirectory.resolve("Dockerfile-remote"), prepareDirectory.resolve("Dockerfile"), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.deleteIfExists(prepareDirectory.resolve("Dockerfile-remote"));
            }
            return;
        }
        String rootTemplateDirectory = ((DockerPackager)this.getPackager()).getTemplateDirectory() + File.separator + ROOT;
        super.doPrepareDistribution(distribution, props, distributionName, prepareDirectory.resolve(ROOT), rootTemplateDirectory, ((DockerPackager)this.packager).getType(), false);
        Files.deleteIfExists(prepareDirectory.resolve(ROOT).resolve("Dockerfile"));
        Files.deleteIfExists(prepareDirectory.resolve(ROOT).resolve("Dockerfile-remote"));
        for (DockerSpec spec : ((DockerPackager)this.packager).getActiveSpecs()) {
            this.prepareSpec(distribution, props, distributionName, prepareDirectory, spec);
        }
    }

    private void prepareSpec(Distribution distribution, TemplateContext props, String distributionName, Path prepareDirectory, DockerSpec spec) throws IOException, PackagerProcessingException {
        TemplateContext newProps = this.fillSpecProps(distribution, props, spec);
        this.context.getLogger().debug(RB.$((String)"distributions.action.preparing", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
        super.doPrepareDistribution(distribution, newProps, distributionName, prepareDirectory.resolve(spec.getName()), spec.getTemplateDirectory(), spec.getName() + "/" + ((DockerPackager)this.packager).getType(), false);
        if (!spec.isUseLocalArtifact()) {
            Files.move(prepareDirectory.resolve(spec.getName()).resolve("Dockerfile-remote"), prepareDirectory.resolve(spec.getName()).resolve("Dockerfile"), StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.deleteIfExists(prepareDirectory.resolve(spec.getName()).resolve("Dockerfile-remote"));
        }
    }

    private TemplateContext fillSpecProps(Distribution distribution, TemplateContext props, DockerSpec spec) {
        List<Artifact> artifacts = Collections.singletonList(spec.getArtifact());
        TemplateContext newProps = this.fillProps(distribution, props);
        newProps.set("dockerSpecName", (Object)spec.getName());
        this.fillDockerProperties(newProps, (DockerConfiguration)spec);
        this.verifyAndAddArtifacts(newProps, distribution, artifacts);
        Path prepareDirectory = (Path)newProps.get("distributionPrepareDirectory");
        newProps.set("distributionPrepareDirectory", (Object)prepareDirectory.resolve(spec.getName()));
        Path packageDirectory = (Path)newProps.get("distributionPackageDirectory");
        newProps.set("distributionPackageDirectory", (Object)packageDirectory.resolve(spec.getName()));
        return newProps;
    }

    @Override
    protected boolean verifyAndAddArtifacts(TemplateContext props, Distribution distribution) {
        if (((DockerPackager)this.packager).getActiveSpecs().isEmpty()) {
            return super.verifyAndAddArtifacts(props, distribution);
        }
        return true;
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        if (((DockerPackager)this.packager).getActiveSpecs().isEmpty()) {
            List artifacts = ((DockerPackager)this.packager).resolveNonOptionalArtifacts(this.context, distribution);
            this.packageDocker(distribution, props, packageDirectory, (DockerConfiguration)this.getPackager(), artifacts);
            return;
        }
        Path rootPrepareDirectory = this.getPrepareDirectory(props).resolve(ROOT);
        Path rootPackageDirectory = this.getPackageDirectory(props).resolve(ROOT);
        this.copyFiles(rootPrepareDirectory, rootPackageDirectory);
        for (DockerSpec spec : ((DockerPackager)this.packager).getActiveSpecs()) {
            this.context.getLogger().debug(RB.$((String)"distributions.action.packaging", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
            TemplateContext newProps = this.fillSpecProps(distribution, props, spec);
            this.packageDocker(distribution, newProps, packageDirectory.resolve(spec.getName()), (DockerConfiguration)spec, Collections.singletonList(spec.getArtifact()));
        }
    }

    protected void packageDocker(Distribution distribution, TemplateContext props, Path packageDirectory, DockerConfiguration docker, List<Artifact> artifacts) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        try {
            Path workingDirectory = this.prepareAssembly(distribution, props, packageDirectory, artifacts);
            Map<String, List<String>> tagNames = this.resolveTagNames(docker, props);
            List<String> tags = tagNames.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            tags.forEach(tag -> this.context.getLogger().info(" - {}", new Object[]{tag}));
            if (docker.getBuildx().isEnabled()) {
                this.createBuildxBuilder(props, docker);
                this.configureAndExecuteBuildCommand(this.buildxBuildCommand(props, docker), workingDirectory, tags);
            } else {
                this.configureAndExecuteBuildCommand(this.buildCommand(props, docker), workingDirectory, tags);
            }
        }
        catch (IOException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    private void configureAndExecuteBuildCommand(Command cmd, Path workingDirectory, List<String> tags) throws PackagerProcessingException {
        if (!cmd.hasArg("-q") && !cmd.hasArg("--quiet")) {
            cmd.arg("--quiet");
        }
        cmd.arg("--file");
        cmd.arg(workingDirectory.resolve("Dockerfile").toAbsolutePath().toString());
        for (String tag : tags) {
            cmd.arg("--tag");
            cmd.arg(tag);
        }
        cmd.arg(workingDirectory.toAbsolutePath().toString());
        this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        this.executeCommand(cmd);
    }

    private void createBuildxBuilder(TemplateContext props, DockerConfiguration docker) throws PackagerProcessingException {
        if (!docker.getBuildx().isCreateBuilder()) {
            return;
        }
        Command cmd = new Command("docker" + (PlatformUtils.isWindows() ? ".exe" : "")).arg("buildx").arg("ls");
        Command.Result result = this.executeCommand(cmd);
        if (result.getOut().contains("jreleaser")) {
            return;
        }
        cmd = this.buildxCreateCommand(props, docker);
        this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        this.executeCommand(cmd);
    }

    private Path prepareAssembly(Distribution distribution, TemplateContext props, Path packageDirectory, List<Artifact> artifacts) throws IOException, PackagerProcessingException {
        this.copyPreparedFiles(props);
        Path assemblyDirectory = packageDirectory.resolve("assembly");
        Files.createDirectories(assemblyDirectory, new FileAttribute[0]);
        for (Artifact artifact : artifacts) {
            Path artifactPath = artifact.getEffectivePath(this.context, distribution);
            if (distribution.getType() == Distribution.DistributionType.BINARY) {
                if (artifactPath.toString().endsWith(".zip")) {
                    FileUtils.unpackArchive((Path)artifactPath, (Path)assemblyDirectory);
                    continue;
                }
                Files.copy(artifactPath, assemblyDirectory.resolve(artifactPath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                continue;
            }
            Files.copy(artifactPath, assemblyDirectory.resolve(artifactPath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        }
        return packageDirectory;
    }

    private Command buildCommand(TemplateContext props, DockerConfiguration docker) {
        Command cmd = this.createCommand("build");
        for (int i = 0; i < docker.getBuildArgs().size(); ++i) {
            String arg = (String)docker.getBuildArgs().get(i);
            if (arg.contains("{{")) {
                cmd.arg(Templates.resolveTemplate((String)arg, (TemplateContext)props).trim());
                continue;
            }
            cmd.arg(arg.trim());
        }
        return cmd;
    }

    private Command buildxBuildCommand(TemplateContext props, DockerConfiguration docker) {
        String arg;
        int i;
        Command cmd = this.createCommand("buildx");
        cmd.arg("build");
        ArrayList<String> platforms = new ArrayList<String>();
        for (i = 0; i < docker.getBuildx().getPlatforms().size(); ++i) {
            arg = (String)docker.getBuildx().getPlatforms().get(i);
            if (arg.contains("{{")) {
                platforms.add(Templates.resolveTemplate((String)arg, (TemplateContext)props).trim());
                continue;
            }
            platforms.add(arg.trim());
        }
        cmd.arg("--platform").arg(String.join((CharSequence)",", platforms));
        for (i = 0; i < docker.getBuildArgs().size(); ++i) {
            arg = (String)docker.getBuildArgs().get(i);
            if (arg.contains("{{")) {
                cmd.arg(Templates.resolveTemplate((String)arg, (TemplateContext)props).trim());
                continue;
            }
            cmd.arg(arg.trim());
        }
        return cmd;
    }

    private Command buildxCreateCommand(TemplateContext props, DockerConfiguration docker) {
        Command cmd = this.createCommand("buildx");
        cmd.arg("create");
        for (int i = 0; i < docker.getBuildx().getCreateBuilderFlags().size(); ++i) {
            String arg = (String)docker.getBuildx().getCreateBuilderFlags().get(i);
            if (arg.contains("{{")) {
                cmd.arg(Templates.resolveTemplate((String)arg, (TemplateContext)props).trim());
                continue;
            }
            cmd.arg(arg.trim());
        }
        return cmd;
    }

    private Command createCommand(String name) {
        return new Command("docker" + (PlatformUtils.isWindows() ? ".exe" : "")).arg("-l").arg("error").arg(name);
    }

    @Override
    public void publishDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        if (((DockerPackager)this.packager).getActiveSpecs().isEmpty()) {
            this.publishToRepository(distribution, props);
            super.publishDistribution(distribution, props);
            this.cleanupBuilder(props, (DockerConfiguration)this.getPackager());
            return;
        }
        this.publishToRepository(distribution, props);
        for (DockerSpec spec : ((DockerPackager)this.packager).getActiveSpecs()) {
            this.context.getLogger().debug(RB.$((String)"distributions.action.publishing", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
            TemplateContext newProps = this.fillSpecProps(distribution, props, spec);
            this.publishDocker(newProps, (DockerConfiguration)spec);
        }
        this.cleanupBuilder(props, ((DockerPackager)this.packager).getActiveSpecs());
    }

    private void publishToRepository(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        super.doPublishDistribution(distribution, this.fillProps(distribution, props));
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        this.publishDocker(props, (DockerConfiguration)this.getPackager());
    }

    protected void publishDocker(TemplateContext props, DockerConfiguration docker) throws PackagerProcessingException {
        Map<String, List<String>> tagNames = this.resolveTagNames(docker, props);
        for (DockerConfiguration.Registry registry : docker.getRegistries()) {
            this.login(registry);
        }
        if (docker.getBuildx().isEnabled()) {
            Path workingDirectory = (Path)props.get("distributionPackageDirectory");
            List list = tagNames.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            Command cmd = this.buildxBuildCommand(props, docker);
            if (!cmd.hasArg("-q") && !cmd.hasArg("--quiet")) {
                cmd.arg("--quiet");
            }
            cmd.arg("--file");
            cmd.arg(workingDirectory.resolve("Dockerfile").toAbsolutePath().toString());
            for (String tag2 : list) {
                cmd.arg("--tag");
                cmd.arg(tag2);
            }
            cmd.arg("--push");
            cmd.arg(workingDirectory.toAbsolutePath().toString());
            this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
            this.executeCommand(cmd);
        } else {
            for (Map.Entry entry : tagNames.entrySet()) {
                Set uniqueImageNames = ((List)entry.getValue()).stream().map(tag -> tag.split(":")[0]).collect(Collectors.toSet());
                for (String imageName : uniqueImageNames) {
                    this.push((String)entry.getKey(), imageName);
                }
            }
        }
        for (DockerConfiguration.Registry registry : docker.getRegistries()) {
            this.logout(registry);
        }
    }

    private void cleanupBuilder(TemplateContext props, DockerConfiguration docker) throws PackagerProcessingException {
        if (docker.getBuildx().isEnabled() && docker.getBuildx().isCreateBuilder()) {
            int i = docker.getBuildx().getCreateBuilderFlags().indexOf("--name");
            String builderName = (String)docker.getBuildx().getCreateBuilderFlags().get(i + 1);
            Command cmd = this.createCommand("buildx").arg("rm").arg(Templates.resolveTemplate((String)builderName, (TemplateContext)props).trim());
            this.executeCommand(cmd);
        }
    }

    private void cleanupBuilder(TemplateContext props, List<DockerSpec> specs) throws PackagerProcessingException {
        LinkedHashSet<String> builderNames = new LinkedHashSet<String>();
        for (DockerSpec spec : specs) {
            if (!spec.getBuildx().isEnabled() || !spec.getBuildx().isCreateBuilder()) continue;
            int i = spec.getBuildx().getCreateBuilderFlags().indexOf("--name");
            builderNames.add((String)spec.getBuildx().getCreateBuilderFlags().get(i + 1));
        }
        for (String builderName : builderNames) {
            Command cmd = this.createCommand("buildx").arg("rm").arg(Templates.resolveTemplate((String)builderName, (TemplateContext)props).trim());
            this.executeCommand(cmd);
        }
    }

    private void login(DockerConfiguration.Registry registry) throws PackagerProcessingException {
        if (registry.isExternalLogin()) {
            return;
        }
        Command cmd = this.createCommand("login");
        if (StringUtils.isNotBlank((String)registry.getServer())) {
            cmd.arg(registry.getServer());
        }
        cmd.arg("-u");
        cmd.arg(registry.getUsername());
        cmd.arg("-p");
        cmd.arg(registry.getPassword());
        ByteArrayInputStream in = new ByteArrayInputStream((registry.getPassword() + System.lineSeparator()).getBytes(StandardCharsets.UTF_8));
        this.context.getLogger().debug(RB.$((String)"docker.login", (Object[])new Object[0]), new Object[]{registry.getServerName(), StringUtils.isNotBlank((String)registry.getServer()) ? " (" + registry.getServer() + ")" : ""});
        if (!this.context.isDryrun()) {
            this.executeCommand(cmd, in);
        }
    }

    private Map<String, List<String>> resolveTagNames(DockerConfiguration docker, TemplateContext props) {
        LinkedHashMap<String, List<String>> tags = new LinkedHashMap<String, List<String>>();
        for (DockerConfiguration.Registry registry : docker.getRegistries()) {
            for (String imageName : docker.getImageNames()) {
                int pos;
                String tag = imageName = Templates.resolveTemplate((String)imageName, (TemplateContext)props).toLowerCase(Locale.ENGLISH);
                String serverName = registry.getServerName();
                String server = registry.getServer();
                String repositoryName = registry.getRepositoryName();
                if ("DEFAULT".equals(serverName)) {
                    if (!tag.startsWith(repositoryName)) {
                        pos = tag.indexOf("/");
                        tag = pos < 0 ? server + "/" + repositoryName + "/" + tag : server + "/" + repositoryName + tag.substring(pos);
                    }
                } else if (!tag.startsWith(server)) {
                    pos = tag.indexOf("/");
                    tag = pos < 0 ? server + "/" + repositoryName + "/" + tag : server + "/" + repositoryName + tag.substring(pos);
                }
                tags.computeIfAbsent(server, k -> new ArrayList()).add(tag);
            }
        }
        return tags;
    }

    private void push(String server, String imageName) throws PackagerProcessingException {
        Command cmd = this.createCommand("push").arg("--quiet").arg("--all-tags").arg(imageName);
        this.context.getLogger().info(" - {}", new Object[]{imageName});
        this.context.getLogger().debug(RB.$((String)"docker.push", (Object[])new Object[]{imageName, server}));
        this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        if (!this.context.isDryrun()) {
            this.executeCommand(cmd);
        }
    }

    private void logout(DockerConfiguration.Registry registry) throws PackagerProcessingException {
        if (registry.isExternalLogin()) {
            return;
        }
        Command cmd = this.createCommand("logout");
        if (StringUtils.isNotBlank((String)registry.getServer())) {
            cmd.arg(registry.getServerName());
        }
        this.context.getLogger().debug(RB.$((String)"docker.logout", (Object[])new Object[0]), new Object[]{registry.getServerName(), StringUtils.isNotBlank((String)registry.getServer()) ? " (" + registry.getServer() + ")" : ""});
        if (!this.context.isDryrun()) {
            this.executeCommand(cmd);
        }
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        props.set("distributionJavaMainClass", (Object)distribution.getJava().getMainClass());
        props.set("distributionJavaMainModule", (Object)distribution.getJava().getMainModule());
        this.fillDockerProperties(props, (DockerConfiguration)this.getPackager());
    }

    protected void fillDockerProperties(TemplateContext props, DockerConfiguration docker) {
        props.set("dockerBaseImage", (Object)Templates.resolveTemplate((String)docker.getBaseImage(), (TemplateContext)props));
        ArrayList labels = new ArrayList();
        docker.getLabels().forEach((label, value) -> labels.add(MustacheUtils.passThrough((String)("\"" + label + "\"=\"" + Templates.resolveTemplate((String)value, (TemplateContext)props) + "\""))));
        props.set("dockerLabels", labels);
        props.set("dockerPreCommands", docker.getPreCommands().stream().map(c -> MustacheUtils.passThrough((String)Templates.resolveTemplate((String)c, (TemplateContext)props))).collect(Collectors.toList()));
        props.set("dockerPostCommands", docker.getPostCommands().stream().map(c -> MustacheUtils.passThrough((String)Templates.resolveTemplate((String)c, (TemplateContext)props))).collect(Collectors.toList()));
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = "executable".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve("assembly").resolve(distribution.getExecutable().getName()) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    @Override
    protected void prepareWorkingCopy(TemplateContext props, Path directory, Distribution distribution) throws IOException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        List activeSpecs = ((DockerPackager)this.packager).getActiveSpecs();
        if (activeSpecs.isEmpty()) {
            for (String imageName : ((DockerPackager)this.packager).getImageNames()) {
                this.copyDockerfiles(packageDirectory, Templates.resolveTemplate((String)imageName, (TemplateContext)props), directory, (DockerConfiguration)this.packager, false);
            }
        } else {
            this.prepareWorkingCopy(packageDirectory.resolve(ROOT), directory);
            for (DockerSpec spec : activeSpecs) {
                TemplateContext newProps = this.fillSpecProps(distribution, props, spec);
                for (String imageName : spec.getImageNames()) {
                    this.copyDockerfiles(packageDirectory.resolve(spec.getName()), Templates.resolveTemplate((String)imageName, (TemplateContext)newProps), directory, (DockerConfiguration)spec, true);
                }
            }
        }
    }

    private void copyDockerfiles(Path source, String imageName, Path directory, DockerConfiguration docker, boolean isSpec) throws IOException {
        Path destination = directory;
        String[] parts = imageName.split("/");
        parts = parts[parts.length - 1].split(":");
        if (isSpec) {
            destination = directory.resolve(parts[0]);
        }
        if (((DockerPackager)this.packager).getPackagerRepository().isVersionedSubfolders()) {
            destination = directory.resolve(parts[1]);
        }
        Path assembly = destination.resolve("assembly");
        FileUtils.deleteFiles((Path)assembly);
        Files.createDirectories(destination, new FileAttribute[0]);
        this.prepareWorkingCopy(source, destination, (Path path) -> !docker.isUseLocalArtifact() && "assembly".equals(path.getFileName().toString()));
    }
}

