/*
 * Decompiled with CFR 0.152.
 */
package jodd.http.upload;

import java.io.IOException;
import java.io.InputStream;
import jodd.http.upload.FileUploadHeader;
import jodd.http.upload.MultipartRequestInputStream;

public abstract class FileUpload {
    protected final MultipartRequestInputStream input;
    protected final int maxFileSize;
    protected final FileUploadHeader header;
    protected boolean valid;
    protected int size = -1;
    protected boolean fileTooBig;

    protected FileUpload(MultipartRequestInputStream input, int maxFileSize) {
        this.input = input;
        this.header = input.lastHeader;
        this.maxFileSize = maxFileSize;
    }

    public FileUploadHeader getHeader() {
        return this.header;
    }

    public abstract byte[] getFileContent() throws IOException;

    public abstract InputStream getFileInputStream() throws IOException;

    public int getSize() {
        return this.size;
    }

    public boolean isUploaded() {
        return this.size != -1;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public boolean isFileTooBig() {
        return this.fileTooBig;
    }

    public abstract boolean isInMemory();

    protected abstract void processStream() throws IOException;

    public String toString() {
        return "FileUpload: uploaded=[" + this.isUploaded() + "] valid=[" + this.valid + "] field=[" + this.header.getFormFieldName() + "] name=[" + this.header.getFileName() + "] size=[" + this.size + ']';
    }
}

