/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.task;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.jodconverter.job.SourceDocumentSpecs;
import org.jodconverter.job.TargetDocumentSpecs;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OnlineOfficeContext;
import org.jodconverter.office.RequestConfig;
import org.jodconverter.task.AbstractOnlineOfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineConversionTask
extends AbstractOnlineOfficeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineConversionTask.class);
    private static final String FILTER_DATA = "FilterData";
    private static final String FILTER_DATA_PREFIX_PARAM = "fd";
    private static final String LOAD_PROPERTIES_PREFIX_PARAM = "l";
    private static final String STORE_PROPERTIES_PREFIX_PARAM = "s";
    private final TargetDocumentSpecs target;

    public OnlineConversionTask(SourceDocumentSpecs source, TargetDocumentSpecs target) {
        super(source);
        this.target = target;
    }

    private void addPropertiesToBuilder(URIBuilder uriBuilder, Map<String, Object> properties, String parameterPrefix) {
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (FILTER_DATA.equalsIgnoreCase(key) && value instanceof Map) {
                    for (Map.Entry fdentry : ((Map)value).entrySet()) {
                        uriBuilder.addParameter(parameterPrefix + FILTER_DATA_PREFIX_PARAM + (String)fdentry.getKey(), fdentry.getValue().toString());
                    }
                    continue;
                }
                if (!(value instanceof String) && !value.getClass().isPrimitive()) continue;
                uriBuilder.addParameter(parameterPrefix + key, value.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OfficeContext context) throws OfficeException {
        LOGGER.info("Executing online conversion task...");
        OnlineOfficeContext onlineContext = (OnlineOfficeContext)context;
        File sourceFile = this.source.getFile();
        try {
            File targetFile = this.target.getFile();
            try {
                HttpEntity entity = MultipartEntityBuilder.create().addPart("data", (ContentBody)new FileBody(sourceFile)).build();
                RequestConfig requestConfig = onlineContext.getRequestConfig();
                URIBuilder uriBuilder = new URIBuilder(this.buildUrl(requestConfig.getUrl()));
                this.addPropertiesToBuilder(uriBuilder, this.target.getFormat().getLoadProperties(), LOAD_PROPERTIES_PREFIX_PARAM);
                this.addPropertiesToBuilder(uriBuilder, this.target.getFormat().getStoreProperties(this.source.getFormat().getInputFamily()), STORE_PROPERTIES_PREFIX_PARAM);
                Executor.newInstance((HttpClient)onlineContext.getHttpClient()).execute(Request.Post((URI)uriBuilder.build()).connectTimeout(requestConfig.getConnectTimeout()).socketTimeout(requestConfig.getSocketTimeout()).body(entity)).saveContent(targetFile);
                this.target.onComplete(targetFile);
            }
            catch (Exception ex) {
                LOGGER.error("Online conversion failed.", (Throwable)ex);
                OfficeException officeEx = new OfficeException("Online conversion failed", (Throwable)ex);
                this.target.onFailure(targetFile, (Exception)officeEx);
                throw officeEx;
            }
        }
        finally {
            this.source.onConsumed(sourceFile);
        }
    }

    private String buildUrl(String connectionUrl) {
        return StringUtils.appendIfMissing((String)connectionUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + this.target.getFormat().getExtension();
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{source=" + this.source + ", target=" + this.target + '}';
    }
}

