/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.io.File;
import java.util.stream.IntStream;
import org.apache.commons.lang3.Validate;
import org.jodconverter.office.AbstractOfficeManagerPool;
import org.jodconverter.office.InstalledOfficeManagerHolder;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OfficeManagerPoolConfig;
import org.jodconverter.office.OnlineOfficeManagerPoolConfig;
import org.jodconverter.office.OnlineOfficeManagerPoolEntry;
import org.jodconverter.office.OnlineOfficeManagerPoolEntryConfig;
import org.jodconverter.ssl.SslConfig;

public final class OnlineOfficeManager
extends AbstractOfficeManagerPool {
    private final int poolSize;
    private final String urlConnection;
    private final SslConfig sslConfig;

    public static Builder builder() {
        return new Builder();
    }

    public static OnlineOfficeManager make(String urlConnection) {
        return OnlineOfficeManager.builder().urlConnection(urlConnection).build();
    }

    public static OnlineOfficeManager install(String urlConnection) {
        return ((Builder)OnlineOfficeManager.builder().urlConnection(urlConnection).install()).build();
    }

    private OnlineOfficeManager(int poolSize, String urlConnection, SslConfig sslConfig, OnlineOfficeManagerPoolConfig config) {
        super(poolSize, (OfficeManagerPoolConfig)config);
        this.poolSize = poolSize;
        this.urlConnection = urlConnection;
        this.sslConfig = sslConfig;
    }

    protected OnlineOfficeManagerPoolEntry[] createPoolEntries() {
        return (OnlineOfficeManagerPoolEntry[])IntStream.range(0, this.poolSize).mapToObj(idx -> new OnlineOfficeManagerPoolEntry(this.urlConnection, this.sslConfig, (OnlineOfficeManagerPoolEntryConfig)this.config)).toArray(OnlineOfficeManagerPoolEntry[]::new);
    }

    public static final class Builder
    extends AbstractOfficeManagerPool.AbstractOfficeManagerPoolBuilder<Builder> {
        public static final int DEFAULT_POOL_SIZE = 1;
        public static final int MAX_POOL_SIZE = 1000;
        private int poolSize = 1;
        private String urlConnection;
        private SslConfig sslConfig;

        private Builder() {
        }

        public OnlineOfficeManager build() {
            Validate.notEmpty((CharSequence)this.urlConnection, (String)"The URL connection is missing", (Object[])new Object[0]);
            if (this.workingDir == null) {
                this.workingDir = new File(System.getProperty("java.io.tmpdir"));
            }
            OnlineOfficeManagerPoolConfig config = new OnlineOfficeManagerPoolConfig(this.workingDir);
            config.setTaskExecutionTimeout(this.taskExecutionTimeout);
            config.setTaskQueueTimeout(this.taskQueueTimeout);
            OnlineOfficeManager manager = new OnlineOfficeManager(this.poolSize, this.urlConnection, this.sslConfig, config);
            if (this.install) {
                InstalledOfficeManagerHolder.setInstance((OfficeManager)manager);
            }
            return manager;
        }

        public Builder poolSize(int poolSize) {
            Validate.inclusiveBetween((long)0L, (long)1000L, (long)poolSize, (String)String.format("The poolSize %s must be between %d and %d", poolSize, 1, 1000));
            this.poolSize = poolSize;
            return this;
        }

        public Builder urlConnection(String urlConnection) {
            Validate.notBlank((CharSequence)urlConnection);
            this.urlConnection = urlConnection;
            return this;
        }

        public Builder sslConfig(SslConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }
    }
}

