/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.AbstractOfficeManagerPool;
import org.jodconverter.core.office.InstalledOfficeManagerHolder;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.OfficeUtils;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.core.util.StringUtils;
import org.jodconverter.local.office.ExistingProcessAction;
import org.jodconverter.local.office.LocalOfficeManagerPoolEntry;
import org.jodconverter.local.office.LocalOfficeProcessManager;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.office.OfficeConnection;
import org.jodconverter.local.office.OfficeUrl;
import org.jodconverter.local.process.ProcessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalOfficeManager
extends AbstractOfficeManagerPool<LocalOfficeManagerPoolEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalOfficeManager.class);
    public static final String DEFAULT_HOSTNAME = "127.0.0.1";
    public static final long DEFAULT_PROCESS_TIMEOUT = 120000L;
    public static final long DEFAULT_PROCESS_RETRY_INTERVAL = 250L;
    public static final long DEFAULT_AFTER_START_PROCESS_DELAY = 0L;
    public static final ExistingProcessAction DEFAULT_EXISTING_PROCESS_ACTION = ExistingProcessAction.KILL;
    public static final boolean DEFAULT_START_FAIL_FAST = false;
    public static final boolean DEFAULT_DISABLE_OPENGL = false;
    public static final boolean DEFAULT_KEEP_ALIVE_ON_SHUTDOWN = false;
    public static final int DEFAULT_MAX_TASKS_PER_PROCESS = 200;
    public static final long MIN_PROCESS_RETRY_INTERVAL = 0L;
    public static final long MAX_PROCESS_RETRY_INTERVAL = 10000L;
    public static final long MIN_AFTER_START_PROCESS_DELAY = 0L;
    public static final long MAX_AFTER_START_PROCESS_DELAY = 10000L;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull LocalOfficeManager make() {
        return LocalOfficeManager.builder().build();
    }

    public static @NonNull LocalOfficeManager install() {
        return ((Builder)LocalOfficeManager.builder().install()).build();
    }

    private LocalOfficeManager(List<OfficeUrl> officeUrls, File officeHome, File workingDir, ProcessManager processManager, List<String> runAsArgs, File templateProfileDir, long processTimeout, long processRetryInterval, long afterStartProcessDelay, ExistingProcessAction existingProcessAction, boolean startFailFast, boolean keepAliveOnShutdown, boolean disableOpengl, int maxTasksPerProcess, long taskExecutionTimeout, long taskQueueTimeout) {
        super(officeUrls.size(), workingDir, taskQueueTimeout);
        this.setEntries(officeUrls.stream().map(officeUrl -> new LocalOfficeManagerPoolEntry(maxTasksPerProcess, taskExecutionTimeout, new LocalOfficeProcessManager((OfficeUrl)officeUrl, officeHome, workingDir, processManager, runAsArgs, templateProfileDir, processTimeout, processRetryInterval, afterStartProcessDelay, existingProcessAction, startFailFast, keepAliveOnShutdown, disableOpengl, new OfficeConnection((OfficeUrl)officeUrl)))).collect(Collectors.toList()));
    }

    public static final class Builder
    extends AbstractOfficeManagerPool.AbstractOfficeManagerPoolBuilder<Builder> {
        private List<String> pipeNames;
        private String hostName = "127.0.0.1";
        private List<Integer> portNumbers;
        private File officeHome = LocalOfficeUtils.getDefaultOfficeHome();
        private ProcessManager processManager = LocalOfficeUtils.findBestProcessManager();
        private List<String> runAsArgs = Collections.emptyList();
        private File templateProfileDir;
        private boolean useDefaultOnInvalidTemplateProfileDir;
        private long processTimeout = 120000L;
        private long processRetryInterval = 250L;
        private long afterStartProcessDelay = 0L;
        private ExistingProcessAction existingProcessAction = DEFAULT_EXISTING_PROCESS_ACTION;
        private boolean startFailFast = false;
        private boolean keepAliveOnShutdown = false;
        private boolean disableOpengl = false;
        private int maxTasksPerProcess = 200;

        private Builder() {
        }

        public @NonNull LocalOfficeManager build() {
            OfficeUtils.validateWorkingDir((File)this.workingDir);
            LocalOfficeUtils.validateOfficeHome(this.officeHome);
            if (this.useDefaultOnInvalidTemplateProfileDir) {
                try {
                    LocalOfficeUtils.validateOfficeTemplateProfileDirectory(this.templateProfileDir);
                }
                catch (IllegalStateException ex) {
                    this.templateProfileDir = null;
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Falling back to default templateProfileDir. Cause: {}", (Object)ex.getMessage());
                    }
                }
            } else {
                LocalOfficeUtils.validateOfficeTemplateProfileDirectory(this.templateProfileDir);
            }
            LocalOfficeManager manager = new LocalOfficeManager(LocalOfficeUtils.buildOfficeUrls(this.hostName, this.portNumbers, this.pipeNames), this.officeHome, this.workingDir, this.processManager, this.runAsArgs, this.templateProfileDir, this.processTimeout, this.processRetryInterval, this.afterStartProcessDelay, this.existingProcessAction, this.startFailFast, this.keepAliveOnShutdown, this.disableOpengl, this.maxTasksPerProcess, this.taskExecutionTimeout, this.taskQueueTimeout);
            if (this.install) {
                InstalledOfficeManagerHolder.setInstance((OfficeManager)manager);
            }
            return manager;
        }

        public @NonNull Builder pipeNames(String ... pipeNames) {
            if (pipeNames != null && pipeNames.length != 0) {
                this.pipeNames = Arrays.asList(pipeNames);
            }
            return this;
        }

        public @NonNull Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public @NonNull Builder portNumbers(int ... portNumbers) {
            if (portNumbers != null && portNumbers.length != 0) {
                this.portNumbers = Arrays.stream(portNumbers).boxed().collect(Collectors.toList());
            }
            return this;
        }

        public @NonNull Builder officeHome(@Nullable File officeHome) {
            if (officeHome != null) {
                this.officeHome = officeHome;
            }
            return this;
        }

        public @NonNull Builder officeHome(@Nullable String officeHome) {
            return StringUtils.isBlank((String)officeHome) ? this : this.officeHome(new File(officeHome));
        }

        public @NonNull Builder processManager(@Nullable ProcessManager processManager) {
            if (processManager != null) {
                this.processManager = processManager;
            }
            return this;
        }

        public @NonNull Builder processManager(@Nullable String processManagerClass) {
            try {
                return StringUtils.isBlank((String)processManagerClass) ? this : this.processManager((ProcessManager)Class.forName(processManagerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new IllegalArgumentException("Could not create a process manager from the specified class name: " + processManagerClass, ex);
            }
        }

        public @NonNull Builder runAsArgs(String ... runAsArgs) {
            if (runAsArgs != null && runAsArgs.length != 0) {
                this.runAsArgs = Collections.unmodifiableList(Arrays.asList(runAsArgs));
            }
            return this;
        }

        public @NonNull Builder templateProfileDir(@Nullable File templateProfileDir) {
            if (templateProfileDir != null) {
                this.templateProfileDir = templateProfileDir;
            }
            return this;
        }

        public @NonNull Builder templateProfileDir(@Nullable String templateProfileDir) {
            return StringUtils.isBlank((String)templateProfileDir) ? this : this.templateProfileDir(new File(templateProfileDir));
        }

        public @NonNull Builder templateProfileDirOrDefault(@Nullable File templateProfileDir) {
            if (templateProfileDir != null) {
                this.useDefaultOnInvalidTemplateProfileDir = true;
                this.templateProfileDir = templateProfileDir;
            }
            return this;
        }

        public @NonNull Builder templateProfileDirOrDefault(@Nullable String templateProfileDir) {
            return StringUtils.isBlank((String)templateProfileDir) ? this : this.templateProfileDirOrDefault(new File(templateProfileDir));
        }

        public @NonNull Builder processTimeout(@Nullable Long processTimeout) {
            if (processTimeout != null) {
                AssertUtils.isTrue((processTimeout >= 0L ? 1 : 0) != 0, (String)String.format("processTimeout %s must be greater than or equal to 0", processTimeout));
                this.processTimeout = processTimeout;
            }
            return this;
        }

        public @NonNull Builder processRetryInterval(@Nullable Long processRetryInterval) {
            if (processRetryInterval != null) {
                AssertUtils.isTrue((processRetryInterval >= 0L && processRetryInterval <= 10000L ? 1 : 0) != 0, (String)String.format("processRetryInterval %s must be in the inclusive range of %s to %s", processRetryInterval, 0L, 10000L));
                this.processRetryInterval = processRetryInterval;
            }
            return this;
        }

        public @NonNull Builder afterStartProcessDelay(@Nullable Long afterStartProcessDelay) {
            if (afterStartProcessDelay != null) {
                AssertUtils.isTrue((afterStartProcessDelay >= 0L && afterStartProcessDelay <= 10000L ? 1 : 0) != 0, (String)String.format("afterStartProcessDelay %s must be in the inclusive range of %s to %s", afterStartProcessDelay, 0L, 10000L));
                this.afterStartProcessDelay = afterStartProcessDelay;
            }
            return this;
        }

        public @NonNull Builder existingProcessAction(@Nullable ExistingProcessAction existingProcessAction) {
            if (existingProcessAction != null) {
                this.existingProcessAction = existingProcessAction;
            }
            return this;
        }

        public @NonNull Builder startFailFast(@Nullable Boolean startFailFast) {
            if (startFailFast != null) {
                this.startFailFast = startFailFast;
            }
            return this;
        }

        public @NonNull Builder keepAliveOnShutdown(@Nullable Boolean keepAliveOnShutdown) {
            if (keepAliveOnShutdown != null) {
                this.keepAliveOnShutdown = keepAliveOnShutdown;
            }
            return this;
        }

        public @NonNull Builder disableOpengl(@Nullable Boolean disableOpengl) {
            if (disableOpengl != null) {
                this.disableOpengl = disableOpengl;
            }
            return this;
        }

        public @NonNull Builder maxTasksPerProcess(@Nullable Integer maxTasksPerProcess) {
            if (maxTasksPerProcess != null) {
                AssertUtils.isTrue((maxTasksPerProcess >= 0 ? 1 : 0) != 0, (String)String.format("maxTasksPerProcess %s must be greater than or equal to 0", maxTasksPerProcess));
                this.maxTasksPerProcess = maxTasksPerProcess;
            }
            return this;
        }
    }
}

