/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.FileByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.log.BlockByteIterator;
import jetbrains.exodus.util.LightOutputStream;
import jetbrains.exodus.vfs.ClusterConverter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\rH\u0002J\u0006\u0010\u0018\u001a\u00020\u000fJ\t\u0010\u0019\u001a\u00020\u001aH\u0096\u0002J\u000e\u0010\u001b\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\t\"\u0004\b\u0012\u0010\u000b\u00a8\u0006#"}, d2={"Ljetbrains/exodus/vfs/Cluster;", "", "", "it", "Ljetbrains/exodus/ByteIterable;", "(Ljetbrains/exodus/ByteIterable;)V", "clusterNumber", "", "getClusterNumber", "()J", "setClusterNumber", "(J)V", "iterator", "Ljetbrains/exodus/ByteIterator;", "size", "", "startingPosition", "getStartingPosition", "setStartingPosition", "copyTo", "", "array", "", "getIterator", "getSize", "hasNext", "", "next", "()Ljava/lang/Byte;", "nextBytes", "off", "len", "skip", "length", "Companion", "xodus-vfs"})
public final class Cluster
implements Iterator<Byte>,
KMappedMarker {
    private ByteIterator iterator;
    private long startingPosition;
    private long clusterNumber;
    private int size;
    private final ByteIterable it;
    public static final Companion Companion = new Companion(null);

    public final long getStartingPosition() {
        return this.startingPosition;
    }

    public final void setStartingPosition(long l) {
        this.startingPosition = l;
    }

    public final long getClusterNumber() {
        return this.clusterNumber;
    }

    public final void setClusterNumber(long l) {
        this.clusterNumber = l;
    }

    public final int getSize() {
        ByteIterator byteIterator;
        ByteIterator $receiver = byteIterator = this.getIterator();
        return this.size;
    }

    @Override
    public boolean hasNext() {
        return this.getSize() > 0;
    }

    @Override
    @NotNull
    public Byte next() {
        Byte by = this.getIterator().next();
        byte it = ((Number)by).byteValue();
        Cluster cluster = this;
        cluster.size += -1;
        int cfr_ignored_0 = cluster.size;
        return by;
    }

    /*
     * WARNING - void declaration
     */
    public final int nextBytes(@NotNull byte[] array, int off, int len) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        ByteIterator iterator = this.getIterator();
        if (iterator instanceof BlockByteIterator) {
            int n;
            int readBytes = n = ((BlockByteIterator)iterator).nextBytes(array, off, len);
            this.size -= readBytes;
            return n;
        }
        int result = Math.min(len, this.size);
        int readBytes = 0;
        int n = result;
        while (readBytes < n) {
            void i;
            array[off + i] = iterator.next();
            ++i;
        }
        this.size -= result;
        return result;
    }

    public final long skip(long length) {
        int size = this.getSize();
        long skipped = length > (long)size ? (long)size : this.getIterator().skip(length);
        this.size -= (int)skipped;
        return skipped;
    }

    public final void copyTo(@NotNull byte[] array) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        int i = 0;
        while (this.hasNext()) {
            array[i++] = this.next();
        }
    }

    private final ByteIterator getIterator() {
        ByteIterator byteIterator = this.iterator;
        if (byteIterator == null) {
            ByteIterator byteIterator2;
            ByteIterator $receiver;
            this.iterator = $receiver = (byteIterator2 = this.it.iterator());
            this.size = IntegerBinding.readCompressed((ByteIterator)$receiver);
            ByteIterator byteIterator3 = byteIterator2;
            byteIterator = byteIterator3;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteIterator3, (String)"it.iterator().apply {\n  \u2026ompressed(this)\n        }");
        }
        return byteIterator;
    }

    public Cluster(@NotNull ByteIterable it) {
        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
        this.it = it;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @JvmStatic
    @NotNull
    public static final ByteIterable writeCluster(@NotNull byte[] cluster, @Nullable ClusterConverter clusterConverter, int size, boolean accumulateInRAM) {
        return Companion.writeCluster(cluster, clusterConverter, size, accumulateInRAM);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Ljetbrains/exodus/vfs/Cluster$Companion;", "", "()V", "writeCluster", "Ljetbrains/exodus/ByteIterable;", "cluster", "", "clusterConverter", "Ljetbrains/exodus/vfs/ClusterConverter;", "size", "", "accumulateInRAM", "", "xodus-vfs"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final ByteIterable writeCluster(@NotNull byte[] cluster, @Nullable ClusterConverter clusterConverter, int size, boolean accumulateInRAM) {
            ByteIterable bi;
            Intrinsics.checkParameterIsNotNull((Object)cluster, (String)"cluster");
            if (accumulateInRAM) {
                LightOutputStream output = new LightOutputStream(size + 5);
                IntegerBinding.writeCompressed((LightOutputStream)output, (int)size);
                output.write(cluster, 0, size);
                ArrayByteIterable result = output.asArrayByteIterable();
                ClusterConverter clusterConverter2 = clusterConverter;
                if (clusterConverter2 == null || (clusterConverter2 = clusterConverter2.onWrite((ByteIterable)result)) == null) {
                    ArrayByteIterable arrayByteIterable = result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)arrayByteIterable, (String)"result");
                    clusterConverter2 = (ByteIterable)arrayByteIterable;
                }
                return clusterConverter2;
            }
            try {
                File file = File.createTempFile("~exodus-vfs-output-cluster", ".tmp");
                Closeable closeable = new RandomAccessFile(file, "rw");
                Throwable throwable = null;
                try {
                    RandomAccessFile out = (RandomAccessFile)closeable;
                    out.write(cluster, 0, size);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                bi = (ByteIterable)new FileByteIterable(file);
                file.deleteOnExit();
            }
            catch (IOException e) {
                RuntimeException runtimeException = ExodusException.toExodusException((Throwable)e);
                Intrinsics.checkExpressionValueIsNotNull((Object)runtimeException, (String)"ExodusException.toExodusException(e)");
                throw (Throwable)runtimeException;
            }
            return (ByteIterable)new CompoundByteIterable(new ByteIterable[]{(ByteIterable)IntegerBinding.intToCompressedEntry((int)size), bi});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

