/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.cached.iterator;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityIdArrayIteratorMultiTypeIdUnpacked
extends NonDisposableEntityIterator {
    private final int[] typeIds;
    private final long[] localIds;
    private int index = 0;

    public EntityIdArrayIteratorMultiTypeIdUnpacked(@NotNull EntityIterableBase iterable, int[] typeIds, long[] localIds) {
        super(iterable);
        this.typeIds = typeIds;
        this.localIds = localIds;
    }

    @Override
    public boolean skip(int number) {
        this.index += number;
        return this.hasNextImpl();
    }

    @Override
    @Nullable
    public EntityId nextId() {
        int index2;
        int typeId;
        return (typeId = this.typeIds[index2 = this.index++]) == Integer.MIN_VALUE ? null : new PersistentEntityId(typeId, this.localIds[index2]);
    }

    @Override
    @Nullable
    public EntityId getLast() {
        int typeId;
        int count = this.localIds.length;
        if (count == 0 || (typeId = this.typeIds[this.typeIds.length - 1]) == Integer.MIN_VALUE) {
            return null;
        }
        return new PersistentEntityId(typeId, this.localIds[count - 1]);
    }

    @Override
    @Nullable
    public EntityId nextIdImpl() {
        int index2;
        int typeId;
        return (typeId = this.typeIds[index2 = this.index++]) == Integer.MIN_VALUE ? null : new PersistentEntityId(typeId, this.localIds[index2]);
    }

    @Override
    protected boolean hasNextImpl() {
        return this.index < this.localIds.length;
    }

    @Override
    protected int getIndex() {
        return this.index;
    }
}

