/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.binop;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.binop.BinaryOperatorEntityIterable;
import jetbrains.exodus.entitystore.iterate.binop.IntersectionIterable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B+\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0015"}, d2={"Ljetbrains/exodus/entitystore/iterate/binop/IntersectionIterable;", "Ljetbrains/exodus/entitystore/iterate/binop/BinaryOperatorEntityIterable;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "iterable1", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "iterable2", "preserveRightOrder", "", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;Z)V", "countImpl", "", "getIterableType", "Ljetbrains/exodus/entitystore/EntityIterableType;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "isEmptyFast", "isEmptyImpl", "Companion", "SortedIterator", "UnsortedIterator", "xodus-entity-store"})
public final class IntersectionIterable
extends BinaryOperatorEntityIterable {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected EntityIterableType getIterableType() {
        return EntityIterableType.INTERSECT;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIteratorBase iterator;
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        EntityIterableBase iterable1 = this.iterable1;
        EntityIterableBase iterable2 = this.iterable2;
        if (this.isSortedById()) {
            EntityIterableBase entityIterableBase = iterable1;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"iterable1");
            if (entityIterableBase.isSortedById()) {
                EntityIterableBase entityIterableBase2 = iterable2;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase2, (String)"iterable2");
                iterator = entityIterableBase2.isSortedById() ? (EntityIteratorBase)new SortedIterator(this, iterable1, iterable2) : (EntityIteratorBase)new UnsortedIterator(this, txn, iterable2, iterable1);
            } else {
                EntityIterableBase entityIterableBase3 = this;
                EntityIterableBase entityIterableBase4 = iterable2;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase4, (String)"iterable2");
                iterator = new UnsortedIterator(entityIterableBase3, txn, iterable1, entityIterableBase4);
            }
        } else {
            EntityIterableBase entityIterableBase = this;
            EntityIterableBase entityIterableBase5 = iterable1;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase5, (String)"iterable1");
            EntityIterableBase entityIterableBase6 = iterable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase6, (String)"iterable2");
            iterator = new UnsortedIterator(entityIterableBase, txn, entityIterableBase5, entityIterableBase6);
        }
        return new EntityIteratorFixingDecorator(this, iterator);
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        return this.isEmptyFast(txn) ? 0L : super.countImpl(txn);
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        return this.isEmptyFast(txn) || super.isEmptyImpl(txn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isEmptyFast(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        if (super.isEmptyFast(txn)) return true;
        EntityIterableBase entityIterableBase = this.iterable1;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"iterable1");
        if (entityIterableBase.isCached() || this.iterable1.nonCachedHasFastCountAndIsEmpty()) {
            if (this.iterable1.isEmptyImpl(txn)) return true;
        }
        EntityIterableBase entityIterableBase2 = this.iterable2;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase2, (String)"iterable2");
        if (!entityIterableBase2.isCached()) {
            if (!this.iterable2.nonCachedHasFastCountAndIsEmpty()) return false;
        }
        if (!this.iterable2.isEmptyImpl(txn)) return false;
        return true;
    }

    @JvmOverloads
    public IntersectionIterable(@Nullable PersistentStoreTransaction txn, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2, boolean preserveRightOrder) {
        Intrinsics.checkParameterIsNotNull((Object)iterable1, (String)"iterable1");
        Intrinsics.checkParameterIsNotNull((Object)iterable2, (String)"iterable2");
        super(txn, iterable1, iterable2, !preserveRightOrder);
        if (preserveRightOrder) {
            EntityIterableBase entityIterableBase = this.iterable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"this.iterable2");
            if (entityIterableBase.isSortedById()) {
                this.depth += 0x20000000;
            }
        } else if (iterable1.isSortedById() || iterable2.isSortedById()) {
            this.depth += 0x20000000;
        }
    }

    @JvmOverloads
    public /* synthetic */ IntersectionIterable(PersistentStoreTransaction persistentStoreTransaction, EntityIterableBase entityIterableBase, EntityIterableBase entityIterableBase2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(persistentStoreTransaction, entityIterableBase, entityIterableBase2, bl);
    }

    @JvmOverloads
    public IntersectionIterable(@Nullable PersistentStoreTransaction txn, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2) {
        this(txn, iterable1, iterable2, false, 8, null);
    }

    static {
        IntersectionIterable.access$registerType$s889122310(EntityIterableType.INTERSECT, Companion.1.INSTANCE);
    }

    public static final /* synthetic */ void access$registerType$s889122310(EntityIterableType type, EntityIterableInstantiator instantiator) {
        EntityIterableBase.registerType(type, instantiator);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0014J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/exodus/entitystore/iterate/binop/IntersectionIterable$SortedIterator;", "Ljetbrains/exodus/entitystore/iterate/NonDisposableEntityIterator;", "iterable", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "iterable1", "iterable2", "(Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;)V", "iterator1", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "iterator2", "nextId", "Ljetbrains/exodus/entitystore/EntityId;", "hasNextImpl", "", "nextIdImpl", "xodus-entity-store"})
    private static final class SortedIterator
    extends NonDisposableEntityIterator {
        private final EntityIteratorBase iterator1;
        private final EntityIteratorBase iterator2;
        private EntityId nextId;

        @Override
        protected boolean hasNextImpl() {
            EntityId next = this.nextId;
            if (next != PersistentEntityId.EMPTY_ID) {
                block9: {
                    next = PersistentEntityId.EMPTY_ID;
                    EntityId e1 = null;
                    EntityId e2 = null;
                    EntityIteratorBase iterator1 = this.iterator1;
                    EntityIteratorBase iterator2 = this.iterator2;
                    while (true) {
                        int cmp;
                        int n;
                        if (e1 == null) {
                            if (!iterator1.hasNext()) break block9;
                            e1 = iterator1.nextId();
                        }
                        if (e2 == null) {
                            if (!iterator2.hasNext()) break block9;
                            e2 = iterator2.nextId();
                        }
                        if (e1 != e2 && (e1 == null || e2 == null)) continue;
                        if (e1 == e2) {
                            n = 0;
                        } else {
                            EntityId entityId = e1;
                            if (entityId == null) {
                                Intrinsics.throwNpe();
                            }
                            EntityId entityId2 = e2;
                            if (entityId2 == null) {
                                Intrinsics.throwNpe();
                            }
                            n = cmp = entityId.compareTo((Object)entityId2);
                        }
                        if (cmp < 0) {
                            e1 = null;
                            continue;
                        }
                        if (cmp <= 0) break;
                        e2 = null;
                    }
                    next = e1;
                }
                this.nextId = next;
                return next != PersistentEntityId.EMPTY_ID;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return this.nextId;
        }

        public SortedIterator(@NotNull EntityIterableBase iterable, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2) {
            Intrinsics.checkParameterIsNotNull((Object)iterable, (String)"iterable");
            Intrinsics.checkParameterIsNotNull((Object)iterable1, (String)"iterable1");
            Intrinsics.checkParameterIsNotNull((Object)iterable2, (String)"iterable2");
            super(iterable);
            EntityIterator entityIterator = iterable1.iterator();
            if (entityIterator == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIteratorBase");
            }
            this.iterator1 = (EntityIteratorBase)entityIterator;
            EntityIterator entityIterator2 = iterable2.iterator();
            if (entityIterator2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIteratorBase");
            }
            this.iterator2 = (EntityIteratorBase)entityIterator2;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/entitystore/iterate/binop/IntersectionIterable$UnsortedIterator;", "Ljetbrains/exodus/entitystore/iterate/NonDisposableEntityIterator;", "iterable", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "iterable1", "iterable2", "(Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;Ljetbrains/exodus/entitystore/PersistentStoreTransaction;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;)V", "entityIdSet", "Ljetbrains/exodus/entitystore/iterate/EntityIdSet;", "iterator2", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "nextId", "Ljetbrains/exodus/entitystore/EntityId;", "getEntityIdSet", "hasNextImpl", "", "nextIdImpl", "xodus-entity-store"})
    private static final class UnsortedIterator
    extends NonDisposableEntityIterator {
        private final EntityIteratorBase iterator2;
        private EntityIdSet entityIdSet;
        private EntityId nextId;
        private final PersistentStoreTransaction txn;
        private final EntityIterableBase iterable1;

        @Override
        protected boolean hasNextImpl() {
            while (this.iterator2.hasNext()) {
                EntityId nextId = this.iterator2.nextId();
                if (!this.getEntityIdSet().contains(nextId)) continue;
                this.nextId = nextId;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return this.nextId;
        }

        private final EntityIdSet getEntityIdSet() {
            EntityIdSet entityIdSet = this.entityIdSet;
            if (entityIdSet == null) {
                EntityIdSet entityIdSet2;
                EntityIdSet $receiver;
                this.entityIdSet = $receiver = (entityIdSet2 = this.iterable1.toSet(this.txn));
                EntityIdSet entityIdSet3 = entityIdSet2;
                entityIdSet = entityIdSet3;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityIdSet3, (String)"iterable1.toSet(txn).apply { entityIdSet = this }");
            }
            return entityIdSet;
        }

        public UnsortedIterator(@NotNull EntityIterableBase iterable, @NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2) {
            Intrinsics.checkParameterIsNotNull((Object)iterable, (String)"iterable");
            Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
            Intrinsics.checkParameterIsNotNull((Object)iterable1, (String)"iterable1");
            Intrinsics.checkParameterIsNotNull((Object)iterable2, (String)"iterable2");
            super(iterable);
            this.txn = txn;
            this.iterable1 = iterable1;
            EntityIterator entityIterator = iterable2.iterator();
            if (entityIterator == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIteratorBase");
            }
            this.iterator2 = (EntityIteratorBase)entityIterator;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/entitystore/iterate/binop/IntersectionIterable$Companion;", "", "()V", "xodus-entity-store"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

